// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Align, BaselinePosition, Box, Buildable, Button, Container, MessageType, Orientable,
    Orientation, ResizeMode, ResponseType, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkInfoBar")]
    pub struct InfoBar(Object<ffi::GtkInfoBar, ffi::GtkInfoBarClass>) @extends Box, Container, Widget, @implements Buildable, Orientable;

    match fn {
        type_ => || ffi::gtk_info_bar_get_type(),
    }
}

impl InfoBar {
    pub const NONE: Option<&'static InfoBar> = None;

    #[doc(alias = "gtk_info_bar_new")]
    pub fn new() -> InfoBar {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_info_bar_new()).unsafe_cast() }
    }

    //#[doc(alias = "gtk_info_bar_new_with_buttons")]
    //#[doc(alias = "new_with_buttons")]
    //pub fn with_buttons(first_button_text: Option<&str>, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> InfoBar {
    //    unsafe { TODO: call ffi:gtk_info_bar_new_with_buttons() }
    //}

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`InfoBar`] objects.
    ///
    /// This method returns an instance of [`InfoBarBuilder`](crate::builders::InfoBarBuilder) which can be used to create [`InfoBar`] objects.
    pub fn builder() -> InfoBarBuilder {
        InfoBarBuilder::new()
    }
}

impl Default for InfoBar {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`InfoBar`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct InfoBarBuilder {
    builder: glib::object::ObjectBuilder<'static, InfoBar>,
}

impl InfoBarBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn message_type(self, message_type: MessageType) -> Self {
        Self {
            builder: self.builder.property("message-type", message_type),
        }
    }

    pub fn revealed(self, revealed: bool) -> Self {
        Self {
            builder: self.builder.property("revealed", revealed),
        }
    }

    pub fn show_close_button(self, show_close_button: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("show-close-button", show_close_button),
        }
    }

    pub fn baseline_position(self, baseline_position: BaselinePosition) -> Self {
        Self {
            builder: self
                .builder
                .property("baseline-position", baseline_position),
        }
    }

    pub fn homogeneous(self, homogeneous: bool) -> Self {
        Self {
            builder: self.builder.property("homogeneous", homogeneous),
        }
    }

    pub fn spacing(self, spacing: i32) -> Self {
        Self {
            builder: self.builder.property("spacing", spacing),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn orientation(self, orientation: Orientation) -> Self {
        Self {
            builder: self.builder.property("orientation", orientation),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`InfoBar`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> InfoBar {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::InfoBar>> Sealed for T {}
}

pub trait InfoBarExt: IsA<InfoBar> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_info_bar_add_action_widget")]
    fn add_action_widget(&self, child: &impl IsA<Widget>, response_id: ResponseType) {
        unsafe {
            ffi::gtk_info_bar_add_action_widget(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                response_id.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_info_bar_add_button")]
    fn add_button(&self, button_text: &str, response_id: ResponseType) -> Option<Button> {
        unsafe {
            from_glib_none(ffi::gtk_info_bar_add_button(
                self.as_ref().to_glib_none().0,
                button_text.to_glib_none().0,
                response_id.into_glib(),
            ))
        }
    }

    //#[doc(alias = "gtk_info_bar_add_buttons")]
    //fn add_buttons(&self, first_button_text: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) {
    //    unsafe { TODO: call ffi:gtk_info_bar_add_buttons() }
    //}

    #[doc(alias = "gtk_info_bar_get_action_area")]
    #[doc(alias = "get_action_area")]
    fn action_area(&self) -> Option<Box> {
        unsafe {
            from_glib_none(ffi::gtk_info_bar_get_action_area(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_info_bar_get_content_area")]
    #[doc(alias = "get_content_area")]
    fn content_area(&self) -> Box {
        unsafe {
            from_glib_none(ffi::gtk_info_bar_get_content_area(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_info_bar_get_message_type")]
    #[doc(alias = "get_message_type")]
    fn message_type(&self) -> MessageType {
        unsafe {
            from_glib(ffi::gtk_info_bar_get_message_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_info_bar_get_revealed")]
    #[doc(alias = "get_revealed")]
    fn is_revealed(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_info_bar_get_revealed(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_info_bar_get_show_close_button")]
    #[doc(alias = "get_show_close_button")]
    fn shows_close_button(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_info_bar_get_show_close_button(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_info_bar_response")]
    fn response(&self, response_id: ResponseType) {
        unsafe {
            ffi::gtk_info_bar_response(self.as_ref().to_glib_none().0, response_id.into_glib());
        }
    }

    #[doc(alias = "gtk_info_bar_set_default_response")]
    fn set_default_response(&self, response_id: ResponseType) {
        unsafe {
            ffi::gtk_info_bar_set_default_response(
                self.as_ref().to_glib_none().0,
                response_id.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_info_bar_set_message_type")]
    fn set_message_type(&self, message_type: MessageType) {
        unsafe {
            ffi::gtk_info_bar_set_message_type(
                self.as_ref().to_glib_none().0,
                message_type.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_info_bar_set_response_sensitive")]
    fn set_response_sensitive(&self, response_id: ResponseType, setting: bool) {
        unsafe {
            ffi::gtk_info_bar_set_response_sensitive(
                self.as_ref().to_glib_none().0,
                response_id.into_glib(),
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_info_bar_set_revealed")]
    fn set_revealed(&self, revealed: bool) {
        unsafe {
            ffi::gtk_info_bar_set_revealed(self.as_ref().to_glib_none().0, revealed.into_glib());
        }
    }

    #[doc(alias = "gtk_info_bar_set_show_close_button")]
    fn set_show_close_button(&self, setting: bool) {
        unsafe {
            ffi::gtk_info_bar_set_show_close_button(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "close")]
    fn connect_close<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn close_trampoline<P: IsA<InfoBar>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkInfoBar,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InfoBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"close\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    close_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_close(&self) {
        self.emit_by_name::<()>("close", &[]);
    }

    #[doc(alias = "response")]
    fn connect_response<F: Fn(&Self, ResponseType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn response_trampoline<
            P: IsA<InfoBar>,
            F: Fn(&P, ResponseType) + 'static,
        >(
            this: *mut ffi::GtkInfoBar,
            response_id: ffi::GtkResponseType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                InfoBar::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(response_id),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"response\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    response_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "message-type")]
    fn connect_message_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_message_type_trampoline<
            P: IsA<InfoBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkInfoBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InfoBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::message-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_message_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "revealed")]
    fn connect_revealed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_revealed_trampoline<P: IsA<InfoBar>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkInfoBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InfoBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::revealed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_revealed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-close-button")]
    fn connect_show_close_button_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_close_button_trampoline<
            P: IsA<InfoBar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkInfoBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InfoBar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-close-button\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_close_button_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<InfoBar>> InfoBarExt for O {}

impl fmt::Display for InfoBar {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("InfoBar")
    }
}
