%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2009-2024. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
%% This file is generated DO NOT EDIT

-module(wxSplitterEvent).
-moduledoc """
This class represents the events generated by a splitter control.

Also there is only one event class, the data associated to the different events is not
the same and so not all accessor functions may be called for each event. The documentation
mentions the kind of event(s) for which the given accessor function makes sense: calling
it for other types of events will result in assert failure (in debug mode) and will return
meaningless results.

See:
* `m:wxSplitterWindow`

* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)

This class is derived, and can use functions, from:

* `m:wxNotifyEvent`

* `m:wxCommandEvent`

* `m:wxEvent`

wxWidgets docs: [wxSplitterEvent](https://docs.wxwidgets.org/3.2/classwx_splitter_event.html)

## Events

Use `wxEvtHandler:connect/3` with `wxSplitterEventType` to subscribe to events of this type.
""".
-include("wxe.hrl").
-export([getSashPosition/1,getWindowBeingRemoved/1,getX/1,getY/1,setSashPosition/2]).

%% inherited exports
-export([allow/1,getClientData/1,getExtraLong/1,getId/1,getInt/1,getSelection/1,
  getSkipped/1,getString/1,getTimestamp/1,isAllowed/1,isChecked/1,isCommandEvent/1,
  isSelection/1,parent_class/1,resumePropagation/2,setInt/2,setString/2,
  shouldPropagate/1,skip/1,skip/2,stopPropagation/1,veto/1]).

-type wxSplitterEvent() :: wx:wx_object().
-include("wx.hrl").
-type wxSplitterEventType() :: 'command_splitter_sash_pos_changed' | 'command_splitter_sash_pos_changing' | 'command_splitter_doubleclicked' | 'command_splitter_unsplit'.
-export_type([wxSplitterEvent/0, wxSplitter/0, wxSplitterEventType/0]).
-doc false.
parent_class(wxNotifyEvent) -> true;
parent_class(wxCommandEvent) -> true;
parent_class(wxEvent) -> true;
parent_class(_Class) -> erlang:error({badtype, ?MODULE}).

-doc """
Returns the new sash position.

May only be called while processing `wxEVT_SPLITTER_SASH_POS_CHANGING` and `wxEVT_SPLITTER_SASH_POS_CHANGED`
events.
""".
-spec getSashPosition(This) -> integer() when
	This::wxSplitterEvent().
getSashPosition(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxSplitterEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxSplitterEvent_GetSashPosition),
  wxe_util:rec(?wxSplitterEvent_GetSashPosition).

-doc """
Returns the x coordinate of the double-click point.

May only be called while processing `wxEVT_SPLITTER_DOUBLECLICKED` events.
""".
-spec getX(This) -> integer() when
	This::wxSplitterEvent().
getX(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxSplitterEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxSplitterEvent_GetX),
  wxe_util:rec(?wxSplitterEvent_GetX).

-doc """
Returns the y coordinate of the double-click point.

May only be called while processing `wxEVT_SPLITTER_DOUBLECLICKED` events.
""".
-spec getY(This) -> integer() when
	This::wxSplitterEvent().
getY(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxSplitterEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxSplitterEvent_GetY),
  wxe_util:rec(?wxSplitterEvent_GetY).

-doc """
Returns a pointer to the window being removed when a splitter window is unsplit.

May only be called while processing `wxEVT_SPLITTER_UNSPLIT` events.
""".
-spec getWindowBeingRemoved(This) -> wxWindow:wxWindow() when
	This::wxSplitterEvent().
getWindowBeingRemoved(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxSplitterEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxSplitterEvent_GetWindowBeingRemoved),
  wxe_util:rec(?wxSplitterEvent_GetWindowBeingRemoved).

-doc """
In the case of `wxEVT\_SPLITTER\_SASH\_POS\_CHANGED` events, sets the new sash position.

In the case of `wxEVT_SPLITTER_SASH_POS_CHANGING` events, sets the new tracking bar
position so visual feedback during dragging will represent that change that will actually
take place. Set to -1 from the event handler code to prevent repositioning.

May only be called while processing `wxEVT_SPLITTER_SASH_POS_CHANGING` and `wxEVT_SPLITTER_SASH_POS_CHANGED`
events.
""".
-spec setSashPosition(This, Pos) -> 'ok' when
	This::wxSplitterEvent(), Pos::integer().
setSashPosition(#wx_ref{type=ThisT}=This,Pos)
 when is_integer(Pos) ->
  ?CLASS(ThisT,wxSplitterEvent),
  wxe_util:queue_cmd(This,Pos,?get_env(),?wxSplitterEvent_SetSashPosition).

 %% From wxNotifyEvent
-doc false.
veto(This) -> wxNotifyEvent:veto(This).
-doc false.
isAllowed(This) -> wxNotifyEvent:isAllowed(This).
-doc false.
allow(This) -> wxNotifyEvent:allow(This).
 %% From wxCommandEvent
-doc false.
setString(This,String) -> wxCommandEvent:setString(This,String).
-doc false.
setInt(This,IntCommand) -> wxCommandEvent:setInt(This,IntCommand).
-doc false.
isSelection(This) -> wxCommandEvent:isSelection(This).
-doc false.
isChecked(This) -> wxCommandEvent:isChecked(This).
-doc false.
getString(This) -> wxCommandEvent:getString(This).
-doc false.
getSelection(This) -> wxCommandEvent:getSelection(This).
-doc false.
getInt(This) -> wxCommandEvent:getInt(This).
-doc false.
getExtraLong(This) -> wxCommandEvent:getExtraLong(This).
-doc false.
getClientData(This) -> wxCommandEvent:getClientData(This).
 %% From wxEvent
-doc false.
stopPropagation(This) -> wxEvent:stopPropagation(This).
-doc false.
skip(This, Options) -> wxEvent:skip(This, Options).
-doc false.
skip(This) -> wxEvent:skip(This).
-doc false.
shouldPropagate(This) -> wxEvent:shouldPropagate(This).
-doc false.
resumePropagation(This,PropagationLevel) -> wxEvent:resumePropagation(This,PropagationLevel).
-doc false.
isCommandEvent(This) -> wxEvent:isCommandEvent(This).
-doc false.
getTimestamp(This) -> wxEvent:getTimestamp(This).
-doc false.
getSkipped(This) -> wxEvent:getSkipped(This).
-doc false.
getId(This) -> wxEvent:getId(This).
