/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2024 Realtek Corporation. All rights reserved
 */

#include "../r8169_compat.h"
#include "../r8169_hw.h"
#include "../r8169_phy.h"
#include "rtl8168g.h"

/* For RTL8168G,RTL8168GU, CFG_METHOD_21,22,24,25 */

/* ------------------------------------MAC 8168G1----------------------------------- */

static void
rtl8168_set_mac_mcu_8168g_1(struct rtl_hw *hw)
{
	rtl_mac_ocp_write(hw, 0xE43C, 0x0000);
	rtl_mac_ocp_write(hw, 0xE43E, 0x0000);

	rtl_mac_ocp_write(hw, 0xE434, 0x0004);
	rtl_mac_ocp_write(hw, 0xE43C, 0x0004);

	rtl_hw_disable_mac_mcu_bps(hw);

	rtl_mac_ocp_write(hw, 0xF800, 0xE008);
	rtl_mac_ocp_write(hw, 0xF802, 0xE01B);
	rtl_mac_ocp_write(hw, 0xF804, 0xE022);
	rtl_mac_ocp_write(hw, 0xF806, 0xE094);
	rtl_mac_ocp_write(hw, 0xF808, 0xE097);
	rtl_mac_ocp_write(hw, 0xF80A, 0xE09A);
	rtl_mac_ocp_write(hw, 0xF80C, 0xE0B3);
	rtl_mac_ocp_write(hw, 0xF80E, 0xE0BA);
	rtl_mac_ocp_write(hw, 0xF810, 0x49D2);
	rtl_mac_ocp_write(hw, 0xF812, 0xF10D);
	rtl_mac_ocp_write(hw, 0xF814, 0x766C);
	rtl_mac_ocp_write(hw, 0xF816, 0x49E2);
	rtl_mac_ocp_write(hw, 0xF818, 0xF00A);
	rtl_mac_ocp_write(hw, 0xF81A, 0x1EC0);
	rtl_mac_ocp_write(hw, 0xF81C, 0x8EE1);
	rtl_mac_ocp_write(hw, 0xF81E, 0xC60A);
	rtl_mac_ocp_write(hw, 0xF820, 0x77C0);
	rtl_mac_ocp_write(hw, 0xF822, 0x4870);
	rtl_mac_ocp_write(hw, 0xF824, 0x9FC0);
	rtl_mac_ocp_write(hw, 0xF826, 0x1EA0);
	rtl_mac_ocp_write(hw, 0xF828, 0xC707);
	rtl_mac_ocp_write(hw, 0xF82A, 0x8EE1);
	rtl_mac_ocp_write(hw, 0xF82C, 0x9D6C);
	rtl_mac_ocp_write(hw, 0xF82E, 0xC603);
	rtl_mac_ocp_write(hw, 0xF830, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF832, 0xB416);
	rtl_mac_ocp_write(hw, 0xF834, 0x0076);
	rtl_mac_ocp_write(hw, 0xF836, 0xE86C);
	rtl_mac_ocp_write(hw, 0xF838, 0xC406);
	rtl_mac_ocp_write(hw, 0xF83A, 0x7580);
	rtl_mac_ocp_write(hw, 0xF83C, 0x4852);
	rtl_mac_ocp_write(hw, 0xF83E, 0x8D80);
	rtl_mac_ocp_write(hw, 0xF840, 0xC403);
	rtl_mac_ocp_write(hw, 0xF842, 0xBC00);
	rtl_mac_ocp_write(hw, 0xF844, 0xD3E0);
	rtl_mac_ocp_write(hw, 0xF846, 0x02C8);
	rtl_mac_ocp_write(hw, 0xF848, 0x8918);
	rtl_mac_ocp_write(hw, 0xF84A, 0xE815);
	rtl_mac_ocp_write(hw, 0xF84C, 0x1100);
	rtl_mac_ocp_write(hw, 0xF84E, 0xF011);
	rtl_mac_ocp_write(hw, 0xF850, 0xE812);
	rtl_mac_ocp_write(hw, 0xF852, 0x4990);
	rtl_mac_ocp_write(hw, 0xF854, 0xF002);
	rtl_mac_ocp_write(hw, 0xF856, 0xE817);
	rtl_mac_ocp_write(hw, 0xF858, 0xE80E);
	rtl_mac_ocp_write(hw, 0xF85A, 0x4992);
	rtl_mac_ocp_write(hw, 0xF85C, 0xF002);
	rtl_mac_ocp_write(hw, 0xF85E, 0xE80E);
	rtl_mac_ocp_write(hw, 0xF860, 0xE80A);
	rtl_mac_ocp_write(hw, 0xF862, 0x4993);
	rtl_mac_ocp_write(hw, 0xF864, 0xF002);
	rtl_mac_ocp_write(hw, 0xF866, 0xE818);
	rtl_mac_ocp_write(hw, 0xF868, 0xE806);
	rtl_mac_ocp_write(hw, 0xF86A, 0x4991);
	rtl_mac_ocp_write(hw, 0xF86C, 0xF002);
	rtl_mac_ocp_write(hw, 0xF86E, 0xE838);
	rtl_mac_ocp_write(hw, 0xF870, 0xC25E);
	rtl_mac_ocp_write(hw, 0xF872, 0xBA00);
	rtl_mac_ocp_write(hw, 0xF874, 0xC056);
	rtl_mac_ocp_write(hw, 0xF876, 0x7100);
	rtl_mac_ocp_write(hw, 0xF878, 0xFF80);
	rtl_mac_ocp_write(hw, 0xF87A, 0x7100);
	rtl_mac_ocp_write(hw, 0xF87C, 0x4892);
	rtl_mac_ocp_write(hw, 0xF87E, 0x4813);
	rtl_mac_ocp_write(hw, 0xF880, 0x8900);
	rtl_mac_ocp_write(hw, 0xF882, 0xE00A);
	rtl_mac_ocp_write(hw, 0xF884, 0x7100);
	rtl_mac_ocp_write(hw, 0xF886, 0x4890);
	rtl_mac_ocp_write(hw, 0xF888, 0x4813);
	rtl_mac_ocp_write(hw, 0xF88A, 0x8900);
	rtl_mac_ocp_write(hw, 0xF88C, 0xC74B);
	rtl_mac_ocp_write(hw, 0xF88E, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF890, 0x48C2);
	rtl_mac_ocp_write(hw, 0xF892, 0x4841);
	rtl_mac_ocp_write(hw, 0xF894, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF896, 0xC746);
	rtl_mac_ocp_write(hw, 0xF898, 0x74FC);
	rtl_mac_ocp_write(hw, 0xF89A, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF89C, 0xF120);
	rtl_mac_ocp_write(hw, 0xF89E, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF8A0, 0xF11E);
	rtl_mac_ocp_write(hw, 0xF8A2, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF8A4, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF8A6, 0xF01B);
	rtl_mac_ocp_write(hw, 0xF8A8, 0x49C6);
	rtl_mac_ocp_write(hw, 0xF8AA, 0xF119);
	rtl_mac_ocp_write(hw, 0xF8AC, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF8AE, 0x49C4);
	rtl_mac_ocp_write(hw, 0xF8B0, 0xF013);
	rtl_mac_ocp_write(hw, 0xF8B2, 0xC536);
	rtl_mac_ocp_write(hw, 0xF8B4, 0x74B0);
	rtl_mac_ocp_write(hw, 0xF8B6, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF8B8, 0xF1FD);
	rtl_mac_ocp_write(hw, 0xF8BA, 0xC537);
	rtl_mac_ocp_write(hw, 0xF8BC, 0xC434);
	rtl_mac_ocp_write(hw, 0xF8BE, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xF8C0, 0xC435);
	rtl_mac_ocp_write(hw, 0xF8C2, 0x1C13);
	rtl_mac_ocp_write(hw, 0xF8C4, 0x484F);
	rtl_mac_ocp_write(hw, 0xF8C6, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xF8C8, 0xC52B);
	rtl_mac_ocp_write(hw, 0xF8CA, 0x74B0);
	rtl_mac_ocp_write(hw, 0xF8CC, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF8CE, 0xF1FD);
	rtl_mac_ocp_write(hw, 0xF8D0, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF8D2, 0x48C4);
	rtl_mac_ocp_write(hw, 0xF8D4, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF8D6, 0x7100);
	rtl_mac_ocp_write(hw, 0xF8D8, 0x4893);
	rtl_mac_ocp_write(hw, 0xF8DA, 0x8900);
	rtl_mac_ocp_write(hw, 0xF8DC, 0xFF80);
	rtl_mac_ocp_write(hw, 0xF8DE, 0xC520);
	rtl_mac_ocp_write(hw, 0xF8E0, 0x74B0);
	rtl_mac_ocp_write(hw, 0xF8E2, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF8E4, 0xF11C);
	rtl_mac_ocp_write(hw, 0xF8E6, 0xC71E);
	rtl_mac_ocp_write(hw, 0xF8E8, 0x74FC);
	rtl_mac_ocp_write(hw, 0xF8EA, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF8EC, 0xF118);
	rtl_mac_ocp_write(hw, 0xF8EE, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF8F0, 0xF116);
	rtl_mac_ocp_write(hw, 0xF8F2, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF8F4, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF8F6, 0xF013);
	rtl_mac_ocp_write(hw, 0xF8F8, 0x48C3);
	rtl_mac_ocp_write(hw, 0xF8FA, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF8FC, 0xC516);
	rtl_mac_ocp_write(hw, 0xF8FE, 0x74A2);
	rtl_mac_ocp_write(hw, 0xF900, 0x49CE);
	rtl_mac_ocp_write(hw, 0xF902, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xF904, 0xC411);
	rtl_mac_ocp_write(hw, 0xF906, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xF908, 0xC411);
	rtl_mac_ocp_write(hw, 0xF90A, 0x1C13);
	rtl_mac_ocp_write(hw, 0xF90C, 0x484F);
	rtl_mac_ocp_write(hw, 0xF90E, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xF910, 0x74A2);
	rtl_mac_ocp_write(hw, 0xF912, 0x49CF);
	rtl_mac_ocp_write(hw, 0xF914, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xF916, 0x7100);
	rtl_mac_ocp_write(hw, 0xF918, 0x4891);
	rtl_mac_ocp_write(hw, 0xF91A, 0x8900);
	rtl_mac_ocp_write(hw, 0xF91C, 0xFF80);
	rtl_mac_ocp_write(hw, 0xF91E, 0xE400);
	rtl_mac_ocp_write(hw, 0xF920, 0xD3E0);
	rtl_mac_ocp_write(hw, 0xF922, 0xE000);
	rtl_mac_ocp_write(hw, 0xF924, 0x0481);
	rtl_mac_ocp_write(hw, 0xF926, 0x0C81);
	rtl_mac_ocp_write(hw, 0xF928, 0xDE20);
	rtl_mac_ocp_write(hw, 0xF92A, 0x0000);
	rtl_mac_ocp_write(hw, 0xF92C, 0x0992);
	rtl_mac_ocp_write(hw, 0xF92E, 0x1B76);
	rtl_mac_ocp_write(hw, 0xF930, 0xC602);
	rtl_mac_ocp_write(hw, 0xF932, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF934, 0x059C);
	rtl_mac_ocp_write(hw, 0xF936, 0x1B76);
	rtl_mac_ocp_write(hw, 0xF938, 0xC602);
	rtl_mac_ocp_write(hw, 0xF93A, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF93C, 0x065A);
	rtl_mac_ocp_write(hw, 0xF93E, 0xB400);
	rtl_mac_ocp_write(hw, 0xF940, 0x18DE);
	rtl_mac_ocp_write(hw, 0xF942, 0x2008);
	rtl_mac_ocp_write(hw, 0xF944, 0x4001);
	rtl_mac_ocp_write(hw, 0xF946, 0xF10F);
	rtl_mac_ocp_write(hw, 0xF948, 0x7342);
	rtl_mac_ocp_write(hw, 0xF94A, 0x1880);
	rtl_mac_ocp_write(hw, 0xF94C, 0x2008);
	rtl_mac_ocp_write(hw, 0xF94E, 0x0009);
	rtl_mac_ocp_write(hw, 0xF950, 0x4018);
	rtl_mac_ocp_write(hw, 0xF952, 0xF109);
	rtl_mac_ocp_write(hw, 0xF954, 0x7340);
	rtl_mac_ocp_write(hw, 0xF956, 0x25BC);
	rtl_mac_ocp_write(hw, 0xF958, 0x130F);
	rtl_mac_ocp_write(hw, 0xF95A, 0xF105);
	rtl_mac_ocp_write(hw, 0xF95C, 0xC00A);
	rtl_mac_ocp_write(hw, 0xF95E, 0x7300);
	rtl_mac_ocp_write(hw, 0xF960, 0x4831);
	rtl_mac_ocp_write(hw, 0xF962, 0x9B00);
	rtl_mac_ocp_write(hw, 0xF964, 0xB000);
	rtl_mac_ocp_write(hw, 0xF966, 0x7340);
	rtl_mac_ocp_write(hw, 0xF968, 0x8320);
	rtl_mac_ocp_write(hw, 0xF96A, 0xC302);
	rtl_mac_ocp_write(hw, 0xF96C, 0xBB00);
	rtl_mac_ocp_write(hw, 0xF96E, 0x0C12);
	rtl_mac_ocp_write(hw, 0xF970, 0xE860);
	rtl_mac_ocp_write(hw, 0xF972, 0xC406);
	rtl_mac_ocp_write(hw, 0xF974, 0x7580);
	rtl_mac_ocp_write(hw, 0xF976, 0x4851);
	rtl_mac_ocp_write(hw, 0xF978, 0x8D80);
	rtl_mac_ocp_write(hw, 0xF97A, 0xC403);
	rtl_mac_ocp_write(hw, 0xF97C, 0xBC00);
	rtl_mac_ocp_write(hw, 0xF97E, 0xD3E0);
	rtl_mac_ocp_write(hw, 0xF980, 0x02C8);
	rtl_mac_ocp_write(hw, 0xF982, 0xC406);
	rtl_mac_ocp_write(hw, 0xF984, 0x7580);
	rtl_mac_ocp_write(hw, 0xF986, 0x4850);
	rtl_mac_ocp_write(hw, 0xF988, 0x8D80);
	rtl_mac_ocp_write(hw, 0xF98A, 0xC403);
	rtl_mac_ocp_write(hw, 0xF98C, 0xBC00);
	rtl_mac_ocp_write(hw, 0xF98E, 0xD3E0);
	rtl_mac_ocp_write(hw, 0xF990, 0x0298);

	rtl_mac_ocp_write(hw, 0xDE30, 0x0080);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC28, 0x0075);
	rtl_mac_ocp_write(hw, 0xFC2A, 0x02B1);
	rtl_mac_ocp_write(hw, 0xFC2C, 0x0991);
	rtl_mac_ocp_write(hw, 0xFC2E, 0x059B);
	rtl_mac_ocp_write(hw, 0xFC30, 0x0659);
	rtl_mac_ocp_write(hw, 0xFC32, 0x0000);
	rtl_mac_ocp_write(hw, 0xFC34, 0x02C7);
	rtl_mac_ocp_write(hw, 0xFC36, 0x0279);
}

/* ------------------------------------MAC 8168GU1---------------------------------- */

static void
rtl8168_set_mac_mcu_8168gu_1(struct rtl_hw *hw)
{
	rtl_hw_disable_mac_mcu_bps(hw);

	rtl_mac_ocp_write(hw, 0xF800, 0xE008);
	rtl_mac_ocp_write(hw, 0xF802, 0xE011);
	rtl_mac_ocp_write(hw, 0xF804, 0xE015);
	rtl_mac_ocp_write(hw, 0xF806, 0xE018);
	rtl_mac_ocp_write(hw, 0xF808, 0xE01B);
	rtl_mac_ocp_write(hw, 0xF80A, 0xE027);
	rtl_mac_ocp_write(hw, 0xF80C, 0xE043);
	rtl_mac_ocp_write(hw, 0xF80E, 0xE065);
	rtl_mac_ocp_write(hw, 0xF810, 0x49E2);
	rtl_mac_ocp_write(hw, 0xF812, 0xF005);
	rtl_mac_ocp_write(hw, 0xF814, 0x49EA);
	rtl_mac_ocp_write(hw, 0xF816, 0xF003);
	rtl_mac_ocp_write(hw, 0xF818, 0xC404);
	rtl_mac_ocp_write(hw, 0xF81A, 0xBC00);
	rtl_mac_ocp_write(hw, 0xF81C, 0xC403);
	rtl_mac_ocp_write(hw, 0xF81E, 0xBC00);
	rtl_mac_ocp_write(hw, 0xF820, 0x0496);
	rtl_mac_ocp_write(hw, 0xF822, 0x051A);
	rtl_mac_ocp_write(hw, 0xF824, 0x1D01);
	rtl_mac_ocp_write(hw, 0xF826, 0x8DE8);
	rtl_mac_ocp_write(hw, 0xF828, 0xC602);
	rtl_mac_ocp_write(hw, 0xF82A, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF82C, 0x0206);
	rtl_mac_ocp_write(hw, 0xF82E, 0x1B76);
	rtl_mac_ocp_write(hw, 0xF830, 0xC202);
	rtl_mac_ocp_write(hw, 0xF832, 0xBA00);
	rtl_mac_ocp_write(hw, 0xF834, 0x058A);
	rtl_mac_ocp_write(hw, 0xF836, 0x1B76);
	rtl_mac_ocp_write(hw, 0xF838, 0xC602);
	rtl_mac_ocp_write(hw, 0xF83A, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF83C, 0x0648);
	rtl_mac_ocp_write(hw, 0xF83E, 0x74E6);
	rtl_mac_ocp_write(hw, 0xF840, 0x1B78);
	rtl_mac_ocp_write(hw, 0xF842, 0x46DC);
	rtl_mac_ocp_write(hw, 0xF844, 0x1300);
	rtl_mac_ocp_write(hw, 0xF846, 0xF005);
	rtl_mac_ocp_write(hw, 0xF848, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF84A, 0x48C3);
	rtl_mac_ocp_write(hw, 0xF84C, 0x48C4);
	rtl_mac_ocp_write(hw, 0xF84E, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF850, 0x64E7);
	rtl_mac_ocp_write(hw, 0xF852, 0xC302);
	rtl_mac_ocp_write(hw, 0xF854, 0xBB00);
	rtl_mac_ocp_write(hw, 0xF856, 0x068E);
	rtl_mac_ocp_write(hw, 0xF858, 0x74E4);
	rtl_mac_ocp_write(hw, 0xF85A, 0x49C5);
	rtl_mac_ocp_write(hw, 0xF85C, 0xF106);
	rtl_mac_ocp_write(hw, 0xF85E, 0x49C6);
	rtl_mac_ocp_write(hw, 0xF860, 0xF107);
	rtl_mac_ocp_write(hw, 0xF862, 0x48C8);
	rtl_mac_ocp_write(hw, 0xF864, 0x48C9);
	rtl_mac_ocp_write(hw, 0xF866, 0xE011);
	rtl_mac_ocp_write(hw, 0xF868, 0x48C9);
	rtl_mac_ocp_write(hw, 0xF86A, 0x4848);
	rtl_mac_ocp_write(hw, 0xF86C, 0xE00E);
	rtl_mac_ocp_write(hw, 0xF86E, 0x4848);
	rtl_mac_ocp_write(hw, 0xF870, 0x49C7);
	rtl_mac_ocp_write(hw, 0xF872, 0xF00A);
	rtl_mac_ocp_write(hw, 0xF874, 0x48C9);
	rtl_mac_ocp_write(hw, 0xF876, 0xC60D);
	rtl_mac_ocp_write(hw, 0xF878, 0x1D1F);
	rtl_mac_ocp_write(hw, 0xF87A, 0x8DC2);
	rtl_mac_ocp_write(hw, 0xF87C, 0x1D00);
	rtl_mac_ocp_write(hw, 0xF87E, 0x8DC3);
	rtl_mac_ocp_write(hw, 0xF880, 0x1D11);
	rtl_mac_ocp_write(hw, 0xF882, 0x8DC0);
	rtl_mac_ocp_write(hw, 0xF884, 0xE002);
	rtl_mac_ocp_write(hw, 0xF886, 0x4849);
	rtl_mac_ocp_write(hw, 0xF888, 0x94E5);
	rtl_mac_ocp_write(hw, 0xF88A, 0xC602);
	rtl_mac_ocp_write(hw, 0xF88C, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF88E, 0x0238);
	rtl_mac_ocp_write(hw, 0xF890, 0xE434);
	rtl_mac_ocp_write(hw, 0xF892, 0x49D9);
	rtl_mac_ocp_write(hw, 0xF894, 0xF01B);
	rtl_mac_ocp_write(hw, 0xF896, 0xC31E);
	rtl_mac_ocp_write(hw, 0xF898, 0x7464);
	rtl_mac_ocp_write(hw, 0xF89A, 0x49C4);
	rtl_mac_ocp_write(hw, 0xF89C, 0xF114);
	rtl_mac_ocp_write(hw, 0xF89E, 0xC31B);
	rtl_mac_ocp_write(hw, 0xF8A0, 0x6460);
	rtl_mac_ocp_write(hw, 0xF8A2, 0x14FA);
	rtl_mac_ocp_write(hw, 0xF8A4, 0xFA02);
	rtl_mac_ocp_write(hw, 0xF8A6, 0xE00F);
	rtl_mac_ocp_write(hw, 0xF8A8, 0xC317);
	rtl_mac_ocp_write(hw, 0xF8AA, 0x7460);
	rtl_mac_ocp_write(hw, 0xF8AC, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF8AE, 0xF10B);
	rtl_mac_ocp_write(hw, 0xF8B0, 0xC311);
	rtl_mac_ocp_write(hw, 0xF8B2, 0x7462);
	rtl_mac_ocp_write(hw, 0xF8B4, 0x48C1);
	rtl_mac_ocp_write(hw, 0xF8B6, 0x9C62);
	rtl_mac_ocp_write(hw, 0xF8B8, 0x4841);
	rtl_mac_ocp_write(hw, 0xF8BA, 0x9C62);
	rtl_mac_ocp_write(hw, 0xF8BC, 0xC30A);
	rtl_mac_ocp_write(hw, 0xF8BE, 0x1C04);
	rtl_mac_ocp_write(hw, 0xF8C0, 0x8C60);
	rtl_mac_ocp_write(hw, 0xF8C2, 0xE004);
	rtl_mac_ocp_write(hw, 0xF8C4, 0x1C15);
	rtl_mac_ocp_write(hw, 0xF8C6, 0xC305);
	rtl_mac_ocp_write(hw, 0xF8C8, 0x8C60);
	rtl_mac_ocp_write(hw, 0xF8CA, 0xC602);
	rtl_mac_ocp_write(hw, 0xF8CC, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF8CE, 0x0374);
	rtl_mac_ocp_write(hw, 0xF8D0, 0xE434);
	rtl_mac_ocp_write(hw, 0xF8D2, 0xE030);
	rtl_mac_ocp_write(hw, 0xF8D4, 0xE61C);
	rtl_mac_ocp_write(hw, 0xF8D6, 0xE906);
	rtl_mac_ocp_write(hw, 0xF8D8, 0xC602);
	rtl_mac_ocp_write(hw, 0xF8DA, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF8DC, 0x0000);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC28, 0x0493);
	rtl_mac_ocp_write(hw, 0xFC2A, 0x0205);
	rtl_mac_ocp_write(hw, 0xFC2C, 0x0589);
	rtl_mac_ocp_write(hw, 0xFC2E, 0x0647);
	rtl_mac_ocp_write(hw, 0xFC30, 0x0000);
	rtl_mac_ocp_write(hw, 0xFC32, 0x0215);
	rtl_mac_ocp_write(hw, 0xFC34, 0x0285);
}

/* ------------------------------------MAC 8168GU2------------------------------------- */

static void
rtl8168_set_mac_mcu_8168gu_2(struct rtl_hw *hw)
{
	rtl_hw_disable_mac_mcu_bps(hw);

	rtl_mac_ocp_write(hw, 0xF800, 0xE008);
	rtl_mac_ocp_write(hw, 0xF802, 0xE00A);
	rtl_mac_ocp_write(hw, 0xF804, 0xE00D);
	rtl_mac_ocp_write(hw, 0xF806, 0xE02F);
	rtl_mac_ocp_write(hw, 0xF808, 0xE031);
	rtl_mac_ocp_write(hw, 0xF80A, 0xE038);
	rtl_mac_ocp_write(hw, 0xF80C, 0xE03A);
	rtl_mac_ocp_write(hw, 0xF80E, 0xE051);
	rtl_mac_ocp_write(hw, 0xF810, 0xC202);
	rtl_mac_ocp_write(hw, 0xF812, 0xBA00);
	rtl_mac_ocp_write(hw, 0xF814, 0x0DFC);
	rtl_mac_ocp_write(hw, 0xF816, 0x7444);
	rtl_mac_ocp_write(hw, 0xF818, 0xC502);
	rtl_mac_ocp_write(hw, 0xF81A, 0xBD00);
	rtl_mac_ocp_write(hw, 0xF81C, 0x0A30);
	rtl_mac_ocp_write(hw, 0xF81E, 0x49D9);
	rtl_mac_ocp_write(hw, 0xF820, 0xF019);
	rtl_mac_ocp_write(hw, 0xF822, 0xC520);
	rtl_mac_ocp_write(hw, 0xF824, 0x64A5);
	rtl_mac_ocp_write(hw, 0xF826, 0x1400);
	rtl_mac_ocp_write(hw, 0xF828, 0xF007);
	rtl_mac_ocp_write(hw, 0xF82A, 0x0C01);
	rtl_mac_ocp_write(hw, 0xF82C, 0x8CA5);
	rtl_mac_ocp_write(hw, 0xF82E, 0x1C15);
	rtl_mac_ocp_write(hw, 0xF830, 0xC515);
	rtl_mac_ocp_write(hw, 0xF832, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xF834, 0xE00F);
	rtl_mac_ocp_write(hw, 0xF836, 0xC513);
	rtl_mac_ocp_write(hw, 0xF838, 0x74A0);
	rtl_mac_ocp_write(hw, 0xF83A, 0x48C8);
	rtl_mac_ocp_write(hw, 0xF83C, 0x48CA);
	rtl_mac_ocp_write(hw, 0xF83E, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xF840, 0xC510);
	rtl_mac_ocp_write(hw, 0xF842, 0x1B00);
	rtl_mac_ocp_write(hw, 0xF844, 0x9BA0);
	rtl_mac_ocp_write(hw, 0xF846, 0x1B1C);
	rtl_mac_ocp_write(hw, 0xF848, 0x483F);
	rtl_mac_ocp_write(hw, 0xF84A, 0x9BA2);
	rtl_mac_ocp_write(hw, 0xF84C, 0x1B04);
	rtl_mac_ocp_write(hw, 0xF84E, 0xC506);
	rtl_mac_ocp_write(hw, 0xF850, 0x9BA0);
	rtl_mac_ocp_write(hw, 0xF852, 0xC603);
	rtl_mac_ocp_write(hw, 0xF854, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF856, 0x0298);
	rtl_mac_ocp_write(hw, 0xF858, 0x03DE);
	rtl_mac_ocp_write(hw, 0xF85A, 0xE434);
	rtl_mac_ocp_write(hw, 0xF85C, 0xE096);
	rtl_mac_ocp_write(hw, 0xF85E, 0xE860);
	rtl_mac_ocp_write(hw, 0xF860, 0xDE20);
	rtl_mac_ocp_write(hw, 0xF862, 0xD3C0);
	rtl_mac_ocp_write(hw, 0xF864, 0xC602);
	rtl_mac_ocp_write(hw, 0xF866, 0xBE00);
	rtl_mac_ocp_write(hw, 0xF868, 0x0A64);
	rtl_mac_ocp_write(hw, 0xF86A, 0xC707);
	rtl_mac_ocp_write(hw, 0xF86C, 0x1D00);
	rtl_mac_ocp_write(hw, 0xF86E, 0x8DE2);
	rtl_mac_ocp_write(hw, 0xF870, 0x48C1);
	rtl_mac_ocp_write(hw, 0xF872, 0xC502);
	rtl_mac_ocp_write(hw, 0xF874, 0xBD00);
	rtl_mac_ocp_write(hw, 0xF876, 0x00AA);
	rtl_mac_ocp_write(hw, 0xF878, 0xE0C0);
	rtl_mac_ocp_write(hw, 0xF87A, 0xC502);
	rtl_mac_ocp_write(hw, 0xF87C, 0xBD00);
	rtl_mac_ocp_write(hw, 0xF87E, 0x0132);
	rtl_mac_ocp_write(hw, 0xF880, 0xC50C);
	rtl_mac_ocp_write(hw, 0xF882, 0x74A2);
	rtl_mac_ocp_write(hw, 0xF884, 0x49CE);
	rtl_mac_ocp_write(hw, 0xF886, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xF888, 0x1C00);
	rtl_mac_ocp_write(hw, 0xF88A, 0x9EA0);
	rtl_mac_ocp_write(hw, 0xF88C, 0x1C1C);
	rtl_mac_ocp_write(hw, 0xF88E, 0x484F);
	rtl_mac_ocp_write(hw, 0xF890, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xF892, 0xC402);
	rtl_mac_ocp_write(hw, 0xF894, 0xBC00);
	rtl_mac_ocp_write(hw, 0xF896, 0x0AFA);
	rtl_mac_ocp_write(hw, 0xF898, 0xDE20);
	rtl_mac_ocp_write(hw, 0xF89A, 0xE000);
	rtl_mac_ocp_write(hw, 0xF89C, 0xE092);
	rtl_mac_ocp_write(hw, 0xF89E, 0xE430);
	rtl_mac_ocp_write(hw, 0xF8A0, 0xDE20);
	rtl_mac_ocp_write(hw, 0xF8A2, 0xE0C0);
	rtl_mac_ocp_write(hw, 0xF8A4, 0xE860);
	rtl_mac_ocp_write(hw, 0xF8A6, 0xE84C);
	rtl_mac_ocp_write(hw, 0xF8A8, 0xB400);
	rtl_mac_ocp_write(hw, 0xF8AA, 0xB430);
	rtl_mac_ocp_write(hw, 0xF8AC, 0xE410);
	rtl_mac_ocp_write(hw, 0xF8AE, 0xC0AE);
	rtl_mac_ocp_write(hw, 0xF8B0, 0xB407);
	rtl_mac_ocp_write(hw, 0xF8B2, 0xB406);
	rtl_mac_ocp_write(hw, 0xF8B4, 0xB405);
	rtl_mac_ocp_write(hw, 0xF8B6, 0xB404);
	rtl_mac_ocp_write(hw, 0xF8B8, 0xB403);
	rtl_mac_ocp_write(hw, 0xF8BA, 0xB402);
	rtl_mac_ocp_write(hw, 0xF8BC, 0xB401);
	rtl_mac_ocp_write(hw, 0xF8BE, 0xC7EE);
	rtl_mac_ocp_write(hw, 0xF8C0, 0x76F4);
	rtl_mac_ocp_write(hw, 0xF8C2, 0xC2ED);
	rtl_mac_ocp_write(hw, 0xF8C4, 0xC3ED);
	rtl_mac_ocp_write(hw, 0xF8C6, 0xC1EF);
	rtl_mac_ocp_write(hw, 0xF8C8, 0xC5F3);
	rtl_mac_ocp_write(hw, 0xF8CA, 0x74A0);
	rtl_mac_ocp_write(hw, 0xF8CC, 0x49CD);
	rtl_mac_ocp_write(hw, 0xF8CE, 0xF001);
	rtl_mac_ocp_write(hw, 0xF8D0, 0xC5EE);
	rtl_mac_ocp_write(hw, 0xF8D2, 0x74A0);
	rtl_mac_ocp_write(hw, 0xF8D4, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF8D6, 0xF105);
	rtl_mac_ocp_write(hw, 0xF8D8, 0xC5E4);
	rtl_mac_ocp_write(hw, 0xF8DA, 0x74A2);
	rtl_mac_ocp_write(hw, 0xF8DC, 0x49CE);
	rtl_mac_ocp_write(hw, 0xF8DE, 0xF00B);
	rtl_mac_ocp_write(hw, 0xF8E0, 0x7444);
	rtl_mac_ocp_write(hw, 0xF8E2, 0x484B);
	rtl_mac_ocp_write(hw, 0xF8E4, 0x9C44);
	rtl_mac_ocp_write(hw, 0xF8E6, 0x1C10);
	rtl_mac_ocp_write(hw, 0xF8E8, 0x9C62);
	rtl_mac_ocp_write(hw, 0xF8EA, 0x1C11);
	rtl_mac_ocp_write(hw, 0xF8EC, 0x8C60);
	rtl_mac_ocp_write(hw, 0xF8EE, 0x1C00);
	rtl_mac_ocp_write(hw, 0xF8F0, 0x9CF6);
	rtl_mac_ocp_write(hw, 0xF8F2, 0xE0EC);
	rtl_mac_ocp_write(hw, 0xF8F4, 0x49E7);
	rtl_mac_ocp_write(hw, 0xF8F6, 0xF016);
	rtl_mac_ocp_write(hw, 0xF8F8, 0x1D80);
	rtl_mac_ocp_write(hw, 0xF8FA, 0x8DF4);
	rtl_mac_ocp_write(hw, 0xF8FC, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF8FE, 0x4843);
	rtl_mac_ocp_write(hw, 0xF900, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF902, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF904, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF906, 0x7444);
	rtl_mac_ocp_write(hw, 0xF908, 0x48C8);
	rtl_mac_ocp_write(hw, 0xF90A, 0x48C9);
	rtl_mac_ocp_write(hw, 0xF90C, 0x48CA);
	rtl_mac_ocp_write(hw, 0xF90E, 0x9C44);
	rtl_mac_ocp_write(hw, 0xF910, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF912, 0x4844);
	rtl_mac_ocp_write(hw, 0xF914, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF916, 0x1E01);
	rtl_mac_ocp_write(hw, 0xF918, 0xE8DB);
	rtl_mac_ocp_write(hw, 0xF91A, 0x7420);
	rtl_mac_ocp_write(hw, 0xF91C, 0x48C1);
	rtl_mac_ocp_write(hw, 0xF91E, 0x9C20);
	rtl_mac_ocp_write(hw, 0xF920, 0xE0D5);
	rtl_mac_ocp_write(hw, 0xF922, 0x49E6);
	rtl_mac_ocp_write(hw, 0xF924, 0xF02A);
	rtl_mac_ocp_write(hw, 0xF926, 0x1D40);
	rtl_mac_ocp_write(hw, 0xF928, 0x8DF4);
	rtl_mac_ocp_write(hw, 0xF92A, 0x74FC);
	rtl_mac_ocp_write(hw, 0xF92C, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF92E, 0xF124);
	rtl_mac_ocp_write(hw, 0xF930, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF932, 0xF122);
	rtl_mac_ocp_write(hw, 0xF934, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF936, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF938, 0xF01F);
	rtl_mac_ocp_write(hw, 0xF93A, 0xE8D3);
	rtl_mac_ocp_write(hw, 0xF93C, 0x48C4);
	rtl_mac_ocp_write(hw, 0xF93E, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF940, 0x1E00);
	rtl_mac_ocp_write(hw, 0xF942, 0xE8C6);
	rtl_mac_ocp_write(hw, 0xF944, 0xC5B1);
	rtl_mac_ocp_write(hw, 0xF946, 0x74A0);
	rtl_mac_ocp_write(hw, 0xF948, 0x49C3);
	rtl_mac_ocp_write(hw, 0xF94A, 0xF016);
	rtl_mac_ocp_write(hw, 0xF94C, 0xC5AF);
	rtl_mac_ocp_write(hw, 0xF94E, 0x74A4);
	rtl_mac_ocp_write(hw, 0xF950, 0x49C2);
	rtl_mac_ocp_write(hw, 0xF952, 0xF005);
	rtl_mac_ocp_write(hw, 0xF954, 0xC5AA);
	rtl_mac_ocp_write(hw, 0xF956, 0x74B2);
	rtl_mac_ocp_write(hw, 0xF958, 0x49C9);
	rtl_mac_ocp_write(hw, 0xF95A, 0xF10E);
	rtl_mac_ocp_write(hw, 0xF95C, 0xC5A6);
	rtl_mac_ocp_write(hw, 0xF95E, 0x74A8);
	rtl_mac_ocp_write(hw, 0xF960, 0x4845);
	rtl_mac_ocp_write(hw, 0xF962, 0x4846);
	rtl_mac_ocp_write(hw, 0xF964, 0x4847);
	rtl_mac_ocp_write(hw, 0xF966, 0x4848);
	rtl_mac_ocp_write(hw, 0xF968, 0x9CA8);
	rtl_mac_ocp_write(hw, 0xF96A, 0x74B2);
	rtl_mac_ocp_write(hw, 0xF96C, 0x4849);
	rtl_mac_ocp_write(hw, 0xF96E, 0x9CB2);
	rtl_mac_ocp_write(hw, 0xF970, 0x74A0);
	rtl_mac_ocp_write(hw, 0xF972, 0x484F);
	rtl_mac_ocp_write(hw, 0xF974, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xF976, 0xE0AA);
	rtl_mac_ocp_write(hw, 0xF978, 0x49E4);
	rtl_mac_ocp_write(hw, 0xF97A, 0xF018);
	rtl_mac_ocp_write(hw, 0xF97C, 0x1D10);
	rtl_mac_ocp_write(hw, 0xF97E, 0x8DF4);
	rtl_mac_ocp_write(hw, 0xF980, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF982, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF984, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF986, 0x4843);
	rtl_mac_ocp_write(hw, 0xF988, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF98A, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF98C, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF98E, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF990, 0x4844);
	rtl_mac_ocp_write(hw, 0xF992, 0x4842);
	rtl_mac_ocp_write(hw, 0xF994, 0x4841);
	rtl_mac_ocp_write(hw, 0xF996, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF998, 0x1E01);
	rtl_mac_ocp_write(hw, 0xF99A, 0xE89A);
	rtl_mac_ocp_write(hw, 0xF99C, 0x7420);
	rtl_mac_ocp_write(hw, 0xF99E, 0x4841);
	rtl_mac_ocp_write(hw, 0xF9A0, 0x9C20);
	rtl_mac_ocp_write(hw, 0xF9A2, 0x7444);
	rtl_mac_ocp_write(hw, 0xF9A4, 0x4848);
	rtl_mac_ocp_write(hw, 0xF9A6, 0x9C44);
	rtl_mac_ocp_write(hw, 0xF9A8, 0xE091);
	rtl_mac_ocp_write(hw, 0xF9AA, 0x49E5);
	rtl_mac_ocp_write(hw, 0xF9AC, 0xF03E);
	rtl_mac_ocp_write(hw, 0xF9AE, 0x1D20);
	rtl_mac_ocp_write(hw, 0xF9B0, 0x8DF4);
	rtl_mac_ocp_write(hw, 0xF9B2, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF9B4, 0x48C2);
	rtl_mac_ocp_write(hw, 0xF9B6, 0x4841);
	rtl_mac_ocp_write(hw, 0xF9B8, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF9BA, 0x1E01);
	rtl_mac_ocp_write(hw, 0xF9BC, 0x7444);
	rtl_mac_ocp_write(hw, 0xF9BE, 0x49CA);
	rtl_mac_ocp_write(hw, 0xF9C0, 0xF103);
	rtl_mac_ocp_write(hw, 0xF9C2, 0x49C2);
	rtl_mac_ocp_write(hw, 0xF9C4, 0xF00C);
	rtl_mac_ocp_write(hw, 0xF9C6, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF9C8, 0xF004);
	rtl_mac_ocp_write(hw, 0xF9CA, 0x6447);
	rtl_mac_ocp_write(hw, 0xF9CC, 0x2244);
	rtl_mac_ocp_write(hw, 0xF9CE, 0xE002);
	rtl_mac_ocp_write(hw, 0xF9D0, 0x1C01);
	rtl_mac_ocp_write(hw, 0xF9D2, 0x9C62);
	rtl_mac_ocp_write(hw, 0xF9D4, 0x1C11);
	rtl_mac_ocp_write(hw, 0xF9D6, 0x8C60);
	rtl_mac_ocp_write(hw, 0xF9D8, 0x1C00);
	rtl_mac_ocp_write(hw, 0xF9DA, 0x9CF6);
	rtl_mac_ocp_write(hw, 0xF9DC, 0x7444);
	rtl_mac_ocp_write(hw, 0xF9DE, 0x49C8);
	rtl_mac_ocp_write(hw, 0xF9E0, 0xF01D);
	rtl_mac_ocp_write(hw, 0xF9E2, 0x74FC);
	rtl_mac_ocp_write(hw, 0xF9E4, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF9E6, 0xF11A);
	rtl_mac_ocp_write(hw, 0xF9E8, 0x49C1);
	rtl_mac_ocp_write(hw, 0xF9EA, 0xF118);
	rtl_mac_ocp_write(hw, 0xF9EC, 0x74F8);
	rtl_mac_ocp_write(hw, 0xF9EE, 0x49C0);
	rtl_mac_ocp_write(hw, 0xF9F0, 0xF015);
	rtl_mac_ocp_write(hw, 0xF9F2, 0x49C6);
	rtl_mac_ocp_write(hw, 0xF9F4, 0xF113);
	rtl_mac_ocp_write(hw, 0xF9F6, 0xE875);
	rtl_mac_ocp_write(hw, 0xF9F8, 0x48C4);
	rtl_mac_ocp_write(hw, 0xF9FA, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xF9FC, 0x7420);
	rtl_mac_ocp_write(hw, 0xF9FE, 0x48C1);
	rtl_mac_ocp_write(hw, 0xFA00, 0x9C20);
	rtl_mac_ocp_write(hw, 0xFA02, 0xC50A);
	rtl_mac_ocp_write(hw, 0xFA04, 0x74A2);
	rtl_mac_ocp_write(hw, 0xFA06, 0x8CA5);
	rtl_mac_ocp_write(hw, 0xFA08, 0x74A0);
	rtl_mac_ocp_write(hw, 0xFA0A, 0xC505);
	rtl_mac_ocp_write(hw, 0xFA0C, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xFA0E, 0x1C11);
	rtl_mac_ocp_write(hw, 0xFA10, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xFA12, 0xE00A);
	rtl_mac_ocp_write(hw, 0xFA14, 0xE434);
	rtl_mac_ocp_write(hw, 0xFA16, 0xD3C0);
	rtl_mac_ocp_write(hw, 0xFA18, 0xDC00);
	rtl_mac_ocp_write(hw, 0xFA1A, 0x7444);
	rtl_mac_ocp_write(hw, 0xFA1C, 0x49CA);
	rtl_mac_ocp_write(hw, 0xFA1E, 0xF004);
	rtl_mac_ocp_write(hw, 0xFA20, 0x48CA);
	rtl_mac_ocp_write(hw, 0xFA22, 0x9C44);
	rtl_mac_ocp_write(hw, 0xFA24, 0xE855);
	rtl_mac_ocp_write(hw, 0xFA26, 0xE052);
	rtl_mac_ocp_write(hw, 0xFA28, 0x49E8);
	rtl_mac_ocp_write(hw, 0xFA2A, 0xF024);
	rtl_mac_ocp_write(hw, 0xFA2C, 0x1D01);
	rtl_mac_ocp_write(hw, 0xFA2E, 0x8DF5);
	rtl_mac_ocp_write(hw, 0xFA30, 0x7440);
	rtl_mac_ocp_write(hw, 0xFA32, 0x49C0);
	rtl_mac_ocp_write(hw, 0xFA34, 0xF11E);
	rtl_mac_ocp_write(hw, 0xFA36, 0x7444);
	rtl_mac_ocp_write(hw, 0xFA38, 0x49C8);
	rtl_mac_ocp_write(hw, 0xFA3A, 0xF01B);
	rtl_mac_ocp_write(hw, 0xFA3C, 0x49CA);
	rtl_mac_ocp_write(hw, 0xFA3E, 0xF119);
	rtl_mac_ocp_write(hw, 0xFA40, 0xC5EC);
	rtl_mac_ocp_write(hw, 0xFA42, 0x76A4);
	rtl_mac_ocp_write(hw, 0xFA44, 0x49E3);
	rtl_mac_ocp_write(hw, 0xFA46, 0xF015);
	rtl_mac_ocp_write(hw, 0xFA48, 0x49C0);
	rtl_mac_ocp_write(hw, 0xFA4A, 0xF103);
	rtl_mac_ocp_write(hw, 0xFA4C, 0x49C1);
	rtl_mac_ocp_write(hw, 0xFA4E, 0xF011);
	rtl_mac_ocp_write(hw, 0xFA50, 0x4849);
	rtl_mac_ocp_write(hw, 0xFA52, 0x9C44);
	rtl_mac_ocp_write(hw, 0xFA54, 0x1C00);
	rtl_mac_ocp_write(hw, 0xFA56, 0x9CF6);
	rtl_mac_ocp_write(hw, 0xFA58, 0x7444);
	rtl_mac_ocp_write(hw, 0xFA5A, 0x49C1);
	rtl_mac_ocp_write(hw, 0xFA5C, 0xF004);
	rtl_mac_ocp_write(hw, 0xFA5E, 0x6446);
	rtl_mac_ocp_write(hw, 0xFA60, 0x1E07);
	rtl_mac_ocp_write(hw, 0xFA62, 0xE003);
	rtl_mac_ocp_write(hw, 0xFA64, 0x1C01);
	rtl_mac_ocp_write(hw, 0xFA66, 0x1E03);
	rtl_mac_ocp_write(hw, 0xFA68, 0x9C62);
	rtl_mac_ocp_write(hw, 0xFA6A, 0x1C11);
	rtl_mac_ocp_write(hw, 0xFA6C, 0x8C60);
	rtl_mac_ocp_write(hw, 0xFA6E, 0xE830);
	rtl_mac_ocp_write(hw, 0xFA70, 0xE02D);
	rtl_mac_ocp_write(hw, 0xFA72, 0x49E9);
	rtl_mac_ocp_write(hw, 0xFA74, 0xF004);
	rtl_mac_ocp_write(hw, 0xFA76, 0x1D02);
	rtl_mac_ocp_write(hw, 0xFA78, 0x8DF5);
	rtl_mac_ocp_write(hw, 0xFA7A, 0xE79C);
	rtl_mac_ocp_write(hw, 0xFA7C, 0x49E3);
	rtl_mac_ocp_write(hw, 0xFA7E, 0xF006);
	rtl_mac_ocp_write(hw, 0xFA80, 0x1D08);
	rtl_mac_ocp_write(hw, 0xFA82, 0x8DF4);
	rtl_mac_ocp_write(hw, 0xFA84, 0x74F8);
	rtl_mac_ocp_write(hw, 0xFA86, 0x74F8);
	rtl_mac_ocp_write(hw, 0xFA88, 0xE73A);
	rtl_mac_ocp_write(hw, 0xFA8A, 0x49E1);
	rtl_mac_ocp_write(hw, 0xFA8C, 0xF007);
	rtl_mac_ocp_write(hw, 0xFA8E, 0x1D02);
	rtl_mac_ocp_write(hw, 0xFA90, 0x8DF4);
	rtl_mac_ocp_write(hw, 0xFA92, 0x1E01);
	rtl_mac_ocp_write(hw, 0xFA94, 0xE7A7);
	rtl_mac_ocp_write(hw, 0xFA96, 0xDE20);
	rtl_mac_ocp_write(hw, 0xFA98, 0xE410);
	rtl_mac_ocp_write(hw, 0xFA9A, 0x49E0);
	rtl_mac_ocp_write(hw, 0xFA9C, 0xF017);
	rtl_mac_ocp_write(hw, 0xFA9E, 0x1D01);
	rtl_mac_ocp_write(hw, 0xFAA0, 0x8DF4);
	rtl_mac_ocp_write(hw, 0xFAA2, 0xC5FA);
	rtl_mac_ocp_write(hw, 0xFAA4, 0x1C00);
	rtl_mac_ocp_write(hw, 0xFAA6, 0x8CA0);
	rtl_mac_ocp_write(hw, 0xFAA8, 0x1C1B);
	rtl_mac_ocp_write(hw, 0xFAAA, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xFAAC, 0x74A2);
	rtl_mac_ocp_write(hw, 0xFAAE, 0x49CF);
	rtl_mac_ocp_write(hw, 0xFAB0, 0xF0FE);
	rtl_mac_ocp_write(hw, 0xFAB2, 0xC5F3);
	rtl_mac_ocp_write(hw, 0xFAB4, 0x74A0);
	rtl_mac_ocp_write(hw, 0xFAB6, 0x4849);
	rtl_mac_ocp_write(hw, 0xFAB8, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xFABA, 0x74F8);
	rtl_mac_ocp_write(hw, 0xFABC, 0x49C0);
	rtl_mac_ocp_write(hw, 0xFABE, 0xF006);
	rtl_mac_ocp_write(hw, 0xFAC0, 0x48C3);
	rtl_mac_ocp_write(hw, 0xFAC2, 0x8CF8);
	rtl_mac_ocp_write(hw, 0xFAC4, 0xE820);
	rtl_mac_ocp_write(hw, 0xFAC6, 0x74F8);
	rtl_mac_ocp_write(hw, 0xFAC8, 0x74F8);
	rtl_mac_ocp_write(hw, 0xFACA, 0xC432);
	rtl_mac_ocp_write(hw, 0xFACC, 0xBC00);
	rtl_mac_ocp_write(hw, 0xFACE, 0xC5E4);
	rtl_mac_ocp_write(hw, 0xFAD0, 0x74A2);
	rtl_mac_ocp_write(hw, 0xFAD2, 0x49CE);
	rtl_mac_ocp_write(hw, 0xFAD4, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xFAD6, 0x9EA0);
	rtl_mac_ocp_write(hw, 0xFAD8, 0x1C1C);
	rtl_mac_ocp_write(hw, 0xFADA, 0x484F);
	rtl_mac_ocp_write(hw, 0xFADC, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xFADE, 0xFF80);
	rtl_mac_ocp_write(hw, 0xFAE0, 0xB404);
	rtl_mac_ocp_write(hw, 0xFAE2, 0xB405);
	rtl_mac_ocp_write(hw, 0xFAE4, 0xC5D9);
	rtl_mac_ocp_write(hw, 0xFAE6, 0x74A2);
	rtl_mac_ocp_write(hw, 0xFAE8, 0x49CE);
	rtl_mac_ocp_write(hw, 0xFAEA, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xFAEC, 0xC41F);
	rtl_mac_ocp_write(hw, 0xFAEE, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xFAF0, 0xC41C);
	rtl_mac_ocp_write(hw, 0xFAF2, 0x1C13);
	rtl_mac_ocp_write(hw, 0xFAF4, 0x484F);
	rtl_mac_ocp_write(hw, 0xFAF6, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xFAF8, 0x74A2);
	rtl_mac_ocp_write(hw, 0xFAFA, 0x49CF);
	rtl_mac_ocp_write(hw, 0xFAFC, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xFAFE, 0xB005);
	rtl_mac_ocp_write(hw, 0xFB00, 0xB004);
	rtl_mac_ocp_write(hw, 0xFB02, 0xFF80);
	rtl_mac_ocp_write(hw, 0xFB04, 0xB404);
	rtl_mac_ocp_write(hw, 0xFB06, 0xB405);
	rtl_mac_ocp_write(hw, 0xFB08, 0xC5C7);
	rtl_mac_ocp_write(hw, 0xFB0A, 0x74A2);
	rtl_mac_ocp_write(hw, 0xFB0C, 0x49CE);
	rtl_mac_ocp_write(hw, 0xFB0E, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xFB10, 0xC40E);
	rtl_mac_ocp_write(hw, 0xFB12, 0x9CA0);
	rtl_mac_ocp_write(hw, 0xFB14, 0xC40A);
	rtl_mac_ocp_write(hw, 0xFB16, 0x1C13);
	rtl_mac_ocp_write(hw, 0xFB18, 0x484F);
	rtl_mac_ocp_write(hw, 0xFB1A, 0x9CA2);
	rtl_mac_ocp_write(hw, 0xFB1C, 0x74A2);
	rtl_mac_ocp_write(hw, 0xFB1E, 0x49CF);
	rtl_mac_ocp_write(hw, 0xFB20, 0xF1FE);
	rtl_mac_ocp_write(hw, 0xFB22, 0xB005);
	rtl_mac_ocp_write(hw, 0xFB24, 0xB004);
	rtl_mac_ocp_write(hw, 0xFB26, 0xFF80);
	rtl_mac_ocp_write(hw, 0xFB28, 0x0000);
	rtl_mac_ocp_write(hw, 0xFB2A, 0x0481);
	rtl_mac_ocp_write(hw, 0xFB2C, 0x0C81);
	rtl_mac_ocp_write(hw, 0xFB2E, 0x0AE0);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC28, 0x0000);
	rtl_mac_ocp_write(hw, 0xFC2A, 0x0000);
	rtl_mac_ocp_write(hw, 0xFC2C, 0x0297);
	rtl_mac_ocp_write(hw, 0xFC2E, 0x0000);
	rtl_mac_ocp_write(hw, 0xFC30, 0x00A9);
	rtl_mac_ocp_write(hw, 0xFC32, 0x012D);
	rtl_mac_ocp_write(hw, 0xFC34, 0x0000);
	rtl_mac_ocp_write(hw, 0xFC36, 0x08DF);
}

/* ------------------------------------PHY 8168G------------------------------------- */

static void
rtl8168_set_phy_mcu_8168g_1(struct rtl_hw *hw)
{
	unsigned int gphy_val;

	rtl_set_phy_mcu_patch_request(hw);
	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8146);
	rtl_mdio_write(hw, 0x14, 0x2300);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0210);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0290);
	rtl_mdio_write(hw, 0x13, 0xA012);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA014);
	rtl_mdio_write(hw, 0x14, 0x2c04);
	rtl_mdio_write(hw, 0x14, 0x2c0c);
	rtl_mdio_write(hw, 0x14, 0x2c6c);
	rtl_mdio_write(hw, 0x14, 0x2d0d);
	rtl_mdio_write(hw, 0x14, 0x31ce);
	rtl_mdio_write(hw, 0x14, 0x506d);
	rtl_mdio_write(hw, 0x14, 0xd708);
	rtl_mdio_write(hw, 0x14, 0x3108);
	rtl_mdio_write(hw, 0x14, 0x106d);
	rtl_mdio_write(hw, 0x14, 0x1560);
	rtl_mdio_write(hw, 0x14, 0x15a9);
	rtl_mdio_write(hw, 0x14, 0x206e);
	rtl_mdio_write(hw, 0x14, 0x175b);
	rtl_mdio_write(hw, 0x14, 0x6062);
	rtl_mdio_write(hw, 0x14, 0xd700);
	rtl_mdio_write(hw, 0x14, 0x5fae);
	rtl_mdio_write(hw, 0x14, 0xd708);
	rtl_mdio_write(hw, 0x14, 0x3107);
	rtl_mdio_write(hw, 0x14, 0x4c1e);
	rtl_mdio_write(hw, 0x14, 0x4169);
	rtl_mdio_write(hw, 0x14, 0x316a);
	rtl_mdio_write(hw, 0x14, 0x0c19);
	rtl_mdio_write(hw, 0x14, 0x31aa);
	rtl_mdio_write(hw, 0x14, 0x0c19);
	rtl_mdio_write(hw, 0x14, 0x2c1b);
	rtl_mdio_write(hw, 0x14, 0x5e62);
	rtl_mdio_write(hw, 0x14, 0x26b5);
	rtl_mdio_write(hw, 0x14, 0x31ab);
	rtl_mdio_write(hw, 0x14, 0x5c1e);
	rtl_mdio_write(hw, 0x14, 0x2c0c);
	rtl_mdio_write(hw, 0x14, 0xc040);
	rtl_mdio_write(hw, 0x14, 0x8808);
	rtl_mdio_write(hw, 0x14, 0xc520);
	rtl_mdio_write(hw, 0x14, 0xc421);
	rtl_mdio_write(hw, 0x14, 0xd05a);
	rtl_mdio_write(hw, 0x14, 0xd19a);
	rtl_mdio_write(hw, 0x14, 0xd709);
	rtl_mdio_write(hw, 0x14, 0x608f);
	rtl_mdio_write(hw, 0x14, 0xd06b);
	rtl_mdio_write(hw, 0x14, 0xd18a);
	rtl_mdio_write(hw, 0x14, 0x2c2c);
	rtl_mdio_write(hw, 0x14, 0xd0be);
	rtl_mdio_write(hw, 0x14, 0xd188);
	rtl_mdio_write(hw, 0x14, 0x2c2c);
	rtl_mdio_write(hw, 0x14, 0xd708);
	rtl_mdio_write(hw, 0x14, 0x4072);
	rtl_mdio_write(hw, 0x14, 0xc104);
	rtl_mdio_write(hw, 0x14, 0x2c3e);
	rtl_mdio_write(hw, 0x14, 0x4076);
	rtl_mdio_write(hw, 0x14, 0xc110);
	rtl_mdio_write(hw, 0x14, 0x2c3e);
	rtl_mdio_write(hw, 0x14, 0x4071);
	rtl_mdio_write(hw, 0x14, 0xc102);
	rtl_mdio_write(hw, 0x14, 0x2c3e);
	rtl_mdio_write(hw, 0x14, 0x4070);
	rtl_mdio_write(hw, 0x14, 0xc101);
	rtl_mdio_write(hw, 0x14, 0x2c3e);
	rtl_mdio_write(hw, 0x14, 0x175b);
	rtl_mdio_write(hw, 0x14, 0xd709);
	rtl_mdio_write(hw, 0x14, 0x3390);
	rtl_mdio_write(hw, 0x14, 0x5c39);
	rtl_mdio_write(hw, 0x14, 0x2c4e);
	rtl_mdio_write(hw, 0x14, 0x175b);
	rtl_mdio_write(hw, 0x14, 0xd708);
	rtl_mdio_write(hw, 0x14, 0x6193);
	rtl_mdio_write(hw, 0x14, 0xd709);
	rtl_mdio_write(hw, 0x14, 0x5f9d);
	rtl_mdio_write(hw, 0x14, 0x408b);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x6042);
	rtl_mdio_write(hw, 0x14, 0xb401);
	rtl_mdio_write(hw, 0x14, 0x175b);
	rtl_mdio_write(hw, 0x14, 0xd708);
	rtl_mdio_write(hw, 0x14, 0x6073);
	rtl_mdio_write(hw, 0x14, 0x5fbc);
	rtl_mdio_write(hw, 0x14, 0x2c4d);
	rtl_mdio_write(hw, 0x14, 0x26ed);
	rtl_mdio_write(hw, 0x14, 0xb280);
	rtl_mdio_write(hw, 0x14, 0xa841);
	rtl_mdio_write(hw, 0x14, 0x9420);
	rtl_mdio_write(hw, 0x14, 0x8710);
	rtl_mdio_write(hw, 0x14, 0xd709);
	rtl_mdio_write(hw, 0x14, 0x42ec);
	rtl_mdio_write(hw, 0x14, 0x606d);
	rtl_mdio_write(hw, 0x14, 0xd207);
	rtl_mdio_write(hw, 0x14, 0x2c57);
	rtl_mdio_write(hw, 0x14, 0xd203);
	rtl_mdio_write(hw, 0x14, 0x33ff);
	rtl_mdio_write(hw, 0x14, 0x563b);
	rtl_mdio_write(hw, 0x14, 0x3275);
	rtl_mdio_write(hw, 0x14, 0x7c5e);
	rtl_mdio_write(hw, 0x14, 0xb240);
	rtl_mdio_write(hw, 0x14, 0xb402);
	rtl_mdio_write(hw, 0x14, 0x263b);
	rtl_mdio_write(hw, 0x14, 0x6096);
	rtl_mdio_write(hw, 0x14, 0xb240);
	rtl_mdio_write(hw, 0x14, 0xb406);
	rtl_mdio_write(hw, 0x14, 0x263b);
	rtl_mdio_write(hw, 0x14, 0x31d7);
	rtl_mdio_write(hw, 0x14, 0x7c67);
	rtl_mdio_write(hw, 0x14, 0xb240);
	rtl_mdio_write(hw, 0x14, 0xb40e);
	rtl_mdio_write(hw, 0x14, 0x263b);
	rtl_mdio_write(hw, 0x14, 0xb410);
	rtl_mdio_write(hw, 0x14, 0x8802);
	rtl_mdio_write(hw, 0x14, 0xb240);
	rtl_mdio_write(hw, 0x14, 0x940e);
	rtl_mdio_write(hw, 0x14, 0x263b);
	rtl_mdio_write(hw, 0x14, 0xba04);
	rtl_mdio_write(hw, 0x14, 0x1cd6);
	rtl_mdio_write(hw, 0x14, 0xa902);
	rtl_mdio_write(hw, 0x14, 0xd711);
	rtl_mdio_write(hw, 0x14, 0x4045);
	rtl_mdio_write(hw, 0x14, 0xa980);
	rtl_mdio_write(hw, 0x14, 0x3003);
	rtl_mdio_write(hw, 0x14, 0x59b1);
	rtl_mdio_write(hw, 0x14, 0xa540);
	rtl_mdio_write(hw, 0x14, 0xa601);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4043);
	rtl_mdio_write(hw, 0x14, 0xa910);
	rtl_mdio_write(hw, 0x14, 0xd711);
	rtl_mdio_write(hw, 0x14, 0x60a0);
	rtl_mdio_write(hw, 0x14, 0xca33);
	rtl_mdio_write(hw, 0x14, 0xcb33);
	rtl_mdio_write(hw, 0x14, 0xa941);
	rtl_mdio_write(hw, 0x14, 0x2c82);
	rtl_mdio_write(hw, 0x14, 0xcaff);
	rtl_mdio_write(hw, 0x14, 0xcbff);
	rtl_mdio_write(hw, 0x14, 0xa921);
	rtl_mdio_write(hw, 0x14, 0xce02);
	rtl_mdio_write(hw, 0x14, 0xe070);
	rtl_mdio_write(hw, 0x14, 0x0f10);
	rtl_mdio_write(hw, 0x14, 0xaf01);
	rtl_mdio_write(hw, 0x14, 0x8f01);
	rtl_mdio_write(hw, 0x14, 0x1766);
	rtl_mdio_write(hw, 0x14, 0x8e02);
	rtl_mdio_write(hw, 0x14, 0x1787);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x609c);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fa4);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0x1ce9);
	rtl_mdio_write(hw, 0x14, 0xce04);
	rtl_mdio_write(hw, 0x14, 0xe070);
	rtl_mdio_write(hw, 0x14, 0x0f20);
	rtl_mdio_write(hw, 0x14, 0xaf01);
	rtl_mdio_write(hw, 0x14, 0x8f01);
	rtl_mdio_write(hw, 0x14, 0x1766);
	rtl_mdio_write(hw, 0x14, 0x8e04);
	rtl_mdio_write(hw, 0x14, 0x6044);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0xa520);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4043);
	rtl_mdio_write(hw, 0x14, 0x2cc1);
	rtl_mdio_write(hw, 0x14, 0xe00f);
	rtl_mdio_write(hw, 0x14, 0x0501);
	rtl_mdio_write(hw, 0x14, 0x1cef);
	rtl_mdio_write(hw, 0x14, 0xb801);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x4060);
	rtl_mdio_write(hw, 0x14, 0x7fc4);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0x1cf5);
	rtl_mdio_write(hw, 0x14, 0xe00f);
	rtl_mdio_write(hw, 0x14, 0x0502);
	rtl_mdio_write(hw, 0x14, 0x1cef);
	rtl_mdio_write(hw, 0x14, 0xb802);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x4061);
	rtl_mdio_write(hw, 0x14, 0x7fc4);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0x1cf5);
	rtl_mdio_write(hw, 0x14, 0xe00f);
	rtl_mdio_write(hw, 0x14, 0x0504);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x6099);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fa4);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0xc17f);
	rtl_mdio_write(hw, 0x14, 0xc200);
	rtl_mdio_write(hw, 0x14, 0xc43f);
	rtl_mdio_write(hw, 0x14, 0xcc03);
	rtl_mdio_write(hw, 0x14, 0xa701);
	rtl_mdio_write(hw, 0x14, 0xa510);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4018);
	rtl_mdio_write(hw, 0x14, 0x9910);
	rtl_mdio_write(hw, 0x14, 0x8510);
	rtl_mdio_write(hw, 0x14, 0x2860);
	rtl_mdio_write(hw, 0x14, 0xe00f);
	rtl_mdio_write(hw, 0x14, 0x0504);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x6099);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fa4);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0xa608);
	rtl_mdio_write(hw, 0x14, 0xc17d);
	rtl_mdio_write(hw, 0x14, 0xc200);
	rtl_mdio_write(hw, 0x14, 0xc43f);
	rtl_mdio_write(hw, 0x14, 0xcc03);
	rtl_mdio_write(hw, 0x14, 0xa701);
	rtl_mdio_write(hw, 0x14, 0xa510);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4018);
	rtl_mdio_write(hw, 0x14, 0x9910);
	rtl_mdio_write(hw, 0x14, 0x8510);
	rtl_mdio_write(hw, 0x14, 0x2926);
	rtl_mdio_write(hw, 0x14, 0x1792);
	rtl_mdio_write(hw, 0x14, 0x27db);
	rtl_mdio_write(hw, 0x14, 0xc000);
	rtl_mdio_write(hw, 0x14, 0xc100);
	rtl_mdio_write(hw, 0x14, 0xc200);
	rtl_mdio_write(hw, 0x14, 0xc300);
	rtl_mdio_write(hw, 0x14, 0xc400);
	rtl_mdio_write(hw, 0x14, 0xc500);
	rtl_mdio_write(hw, 0x14, 0xc600);
	rtl_mdio_write(hw, 0x14, 0xc7c1);
	rtl_mdio_write(hw, 0x14, 0xc800);
	rtl_mdio_write(hw, 0x14, 0xcc00);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x14, 0xca0f);
	rtl_mdio_write(hw, 0x14, 0xcbff);
	rtl_mdio_write(hw, 0x14, 0xa901);
	rtl_mdio_write(hw, 0x14, 0x8902);
	rtl_mdio_write(hw, 0x14, 0xc900);
	rtl_mdio_write(hw, 0x14, 0xca00);
	rtl_mdio_write(hw, 0x14, 0xcb00);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x14, 0xb804);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x6044);
	rtl_mdio_write(hw, 0x14, 0x9804);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x6099);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fa4);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x14, 0xa510);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x6098);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fa4);
	rtl_mdio_write(hw, 0x14, 0x2cd4);
	rtl_mdio_write(hw, 0x14, 0x8510);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x14, 0xd711);
	rtl_mdio_write(hw, 0x14, 0x3003);
	rtl_mdio_write(hw, 0x14, 0x1d01);
	rtl_mdio_write(hw, 0x14, 0x2d0b);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x60be);
	rtl_mdio_write(hw, 0x14, 0xe060);
	rtl_mdio_write(hw, 0x14, 0x0920);
	rtl_mdio_write(hw, 0x14, 0x1cd6);
	rtl_mdio_write(hw, 0x14, 0x2c89);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x3063);
	rtl_mdio_write(hw, 0x14, 0x1948);
	rtl_mdio_write(hw, 0x14, 0x288a);
	rtl_mdio_write(hw, 0x14, 0x1cd6);
	rtl_mdio_write(hw, 0x14, 0x29bd);
	rtl_mdio_write(hw, 0x14, 0xa802);
	rtl_mdio_write(hw, 0x14, 0xa303);
	rtl_mdio_write(hw, 0x14, 0x843f);
	rtl_mdio_write(hw, 0x14, 0x81ff);
	rtl_mdio_write(hw, 0x14, 0x8208);
	rtl_mdio_write(hw, 0x14, 0xa201);
	rtl_mdio_write(hw, 0x14, 0xc001);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x30a0);
	rtl_mdio_write(hw, 0x14, 0x0d1c);
	rtl_mdio_write(hw, 0x14, 0x30a0);
	rtl_mdio_write(hw, 0x14, 0x3d13);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7f4c);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0xe003);
	rtl_mdio_write(hw, 0x14, 0x0202);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x6090);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fac);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0xa20c);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x6091);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fac);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0x820e);
	rtl_mdio_write(hw, 0x14, 0xa3e0);
	rtl_mdio_write(hw, 0x14, 0xa520);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x609d);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fac);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0x8520);
	rtl_mdio_write(hw, 0x14, 0x6703);
	rtl_mdio_write(hw, 0x14, 0x2d34);
	rtl_mdio_write(hw, 0x14, 0xa13e);
	rtl_mdio_write(hw, 0x14, 0xc001);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4000);
	rtl_mdio_write(hw, 0x14, 0x6046);
	rtl_mdio_write(hw, 0x14, 0x2d0d);
	rtl_mdio_write(hw, 0x14, 0xa43f);
	rtl_mdio_write(hw, 0x14, 0xa101);
	rtl_mdio_write(hw, 0x14, 0xc020);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x3121);
	rtl_mdio_write(hw, 0x14, 0x0d45);
	rtl_mdio_write(hw, 0x14, 0x30c0);
	rtl_mdio_write(hw, 0x14, 0x3d0d);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7f4c);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0xa540);
	rtl_mdio_write(hw, 0x14, 0xc001);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4001);
	rtl_mdio_write(hw, 0x14, 0xe00f);
	rtl_mdio_write(hw, 0x14, 0x0501);
	rtl_mdio_write(hw, 0x14, 0x1dac);
	rtl_mdio_write(hw, 0x14, 0xc1c4);
	rtl_mdio_write(hw, 0x14, 0xa268);
	rtl_mdio_write(hw, 0x14, 0xa303);
	rtl_mdio_write(hw, 0x14, 0x8420);
	rtl_mdio_write(hw, 0x14, 0xe00f);
	rtl_mdio_write(hw, 0x14, 0x0502);
	rtl_mdio_write(hw, 0x14, 0x1dac);
	rtl_mdio_write(hw, 0x14, 0xc002);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4000);
	rtl_mdio_write(hw, 0x14, 0x8208);
	rtl_mdio_write(hw, 0x14, 0x8410);
	rtl_mdio_write(hw, 0x14, 0xa121);
	rtl_mdio_write(hw, 0x14, 0xc002);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4000);
	rtl_mdio_write(hw, 0x14, 0x8120);
	rtl_mdio_write(hw, 0x14, 0x8180);
	rtl_mdio_write(hw, 0x14, 0x1d97);
	rtl_mdio_write(hw, 0x14, 0xa180);
	rtl_mdio_write(hw, 0x14, 0xa13a);
	rtl_mdio_write(hw, 0x14, 0x8240);
	rtl_mdio_write(hw, 0x14, 0xa430);
	rtl_mdio_write(hw, 0x14, 0xc010);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x30e1);
	rtl_mdio_write(hw, 0x14, 0x0abc);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7f8c);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0xa480);
	rtl_mdio_write(hw, 0x14, 0xa230);
	rtl_mdio_write(hw, 0x14, 0xa303);
	rtl_mdio_write(hw, 0x14, 0xc001);
	rtl_mdio_write(hw, 0x14, 0xd70c);
	rtl_mdio_write(hw, 0x14, 0x4124);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x6120);
	rtl_mdio_write(hw, 0x14, 0xd711);
	rtl_mdio_write(hw, 0x14, 0x3128);
	rtl_mdio_write(hw, 0x14, 0x3d76);
	rtl_mdio_write(hw, 0x14, 0x2d70);
	rtl_mdio_write(hw, 0x14, 0xa801);
	rtl_mdio_write(hw, 0x14, 0x2d6c);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4000);
	rtl_mdio_write(hw, 0x14, 0xe018);
	rtl_mdio_write(hw, 0x14, 0x0208);
	rtl_mdio_write(hw, 0x14, 0xa1f8);
	rtl_mdio_write(hw, 0x14, 0x8480);
	rtl_mdio_write(hw, 0x14, 0xc004);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4000);
	rtl_mdio_write(hw, 0x14, 0x6046);
	rtl_mdio_write(hw, 0x14, 0x2d0d);
	rtl_mdio_write(hw, 0x14, 0xa43f);
	rtl_mdio_write(hw, 0x14, 0xa105);
	rtl_mdio_write(hw, 0x14, 0x8228);
	rtl_mdio_write(hw, 0x14, 0xc004);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4000);
	rtl_mdio_write(hw, 0x14, 0x81bc);
	rtl_mdio_write(hw, 0x14, 0xa220);
	rtl_mdio_write(hw, 0x14, 0x1d97);
	rtl_mdio_write(hw, 0x14, 0x8220);
	rtl_mdio_write(hw, 0x14, 0xa1bc);
	rtl_mdio_write(hw, 0x14, 0xc040);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x30e1);
	rtl_mdio_write(hw, 0x14, 0x0abc);
	rtl_mdio_write(hw, 0x14, 0x30e1);
	rtl_mdio_write(hw, 0x14, 0x3d0d);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7f4c);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0xa802);
	rtl_mdio_write(hw, 0x14, 0xd70c);
	rtl_mdio_write(hw, 0x14, 0x4244);
	rtl_mdio_write(hw, 0x14, 0xa301);
	rtl_mdio_write(hw, 0x14, 0xc004);
	rtl_mdio_write(hw, 0x14, 0xd711);
	rtl_mdio_write(hw, 0x14, 0x3128);
	rtl_mdio_write(hw, 0x14, 0x3da5);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x5f80);
	rtl_mdio_write(hw, 0x14, 0xd711);
	rtl_mdio_write(hw, 0x14, 0x3109);
	rtl_mdio_write(hw, 0x14, 0x3da7);
	rtl_mdio_write(hw, 0x14, 0x2dab);
	rtl_mdio_write(hw, 0x14, 0xa801);
	rtl_mdio_write(hw, 0x14, 0x2d9a);
	rtl_mdio_write(hw, 0x14, 0xa802);
	rtl_mdio_write(hw, 0x14, 0xc004);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x4000);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x14, 0xa510);
	rtl_mdio_write(hw, 0x14, 0xd710);
	rtl_mdio_write(hw, 0x14, 0x609a);
	rtl_mdio_write(hw, 0x14, 0xd71e);
	rtl_mdio_write(hw, 0x14, 0x7fac);
	rtl_mdio_write(hw, 0x14, 0x2ab6);
	rtl_mdio_write(hw, 0x14, 0x8510);
	rtl_mdio_write(hw, 0x14, 0x0800);
	rtl_mdio_write(hw, 0x13, 0xA01A);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xA006);
	rtl_mdio_write(hw, 0x14, 0x0ad6);
	rtl_mdio_write(hw, 0x13, 0xA004);
	rtl_mdio_write(hw, 0x14, 0x07f5);
	rtl_mdio_write(hw, 0x13, 0xA002);
	rtl_mdio_write(hw, 0x14, 0x06a9);
	rtl_mdio_write(hw, 0x13, 0xA000);
	rtl_mdio_write(hw, 0x14, 0xf069);
	rtl_mdio_write(hw, 0x13, 0xB820);
	rtl_mdio_write(hw, 0x14, 0x0210);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x83a0);
	rtl_mdio_write(hw, 0x14, 0xaf83);
	rtl_mdio_write(hw, 0x14, 0xacaf);
	rtl_mdio_write(hw, 0x14, 0x83b8);
	rtl_mdio_write(hw, 0x14, 0xaf83);
	rtl_mdio_write(hw, 0x14, 0xcdaf);
	rtl_mdio_write(hw, 0x14, 0x83d3);
	rtl_mdio_write(hw, 0x14, 0x0204);
	rtl_mdio_write(hw, 0x14, 0x9a02);
	rtl_mdio_write(hw, 0x14, 0x09a9);
	rtl_mdio_write(hw, 0x14, 0x0284);
	rtl_mdio_write(hw, 0x14, 0x61af);
	rtl_mdio_write(hw, 0x14, 0x02fc);
	rtl_mdio_write(hw, 0x14, 0xad20);
	rtl_mdio_write(hw, 0x14, 0x0302);
	rtl_mdio_write(hw, 0x14, 0x867c);
	rtl_mdio_write(hw, 0x14, 0xad21);
	rtl_mdio_write(hw, 0x14, 0x0302);
	rtl_mdio_write(hw, 0x14, 0x85c9);
	rtl_mdio_write(hw, 0x14, 0xad22);
	rtl_mdio_write(hw, 0x14, 0x0302);
	rtl_mdio_write(hw, 0x14, 0x1bc0);
	rtl_mdio_write(hw, 0x14, 0xaf17);
	rtl_mdio_write(hw, 0x14, 0xe302);
	rtl_mdio_write(hw, 0x14, 0x8703);
	rtl_mdio_write(hw, 0x14, 0xaf18);
	rtl_mdio_write(hw, 0x14, 0x6201);
	rtl_mdio_write(hw, 0x14, 0x06e0);
	rtl_mdio_write(hw, 0x14, 0x8148);
	rtl_mdio_write(hw, 0x14, 0xaf3c);
	rtl_mdio_write(hw, 0x14, 0x69f8);
	rtl_mdio_write(hw, 0x14, 0xf9fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0x10f7);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0x131f);
	rtl_mdio_write(hw, 0x14, 0xd104);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0xf302);
	rtl_mdio_write(hw, 0x14, 0x4259);
	rtl_mdio_write(hw, 0x14, 0x0287);
	rtl_mdio_write(hw, 0x14, 0x88bf);
	rtl_mdio_write(hw, 0x14, 0x87cf);
	rtl_mdio_write(hw, 0x14, 0xd7b8);
	rtl_mdio_write(hw, 0x14, 0x22d0);
	rtl_mdio_write(hw, 0x14, 0x0c02);
	rtl_mdio_write(hw, 0x14, 0x4252);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0xcda0);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0xce8b);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0xd1f5);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0xd2a9);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0xd30a);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0xf010);
	rtl_mdio_write(hw, 0x14, 0xee80);
	rtl_mdio_write(hw, 0x14, 0xf38f);
	rtl_mdio_write(hw, 0x14, 0xee81);
	rtl_mdio_write(hw, 0x14, 0x011e);
	rtl_mdio_write(hw, 0x14, 0xee81);
	rtl_mdio_write(hw, 0x14, 0x0b4a);
	rtl_mdio_write(hw, 0x14, 0xee81);
	rtl_mdio_write(hw, 0x14, 0x0c7c);
	rtl_mdio_write(hw, 0x14, 0xee81);
	rtl_mdio_write(hw, 0x14, 0x127f);
	rtl_mdio_write(hw, 0x14, 0xd100);
	rtl_mdio_write(hw, 0x14, 0x0210);
	rtl_mdio_write(hw, 0x14, 0xb5ee);
	rtl_mdio_write(hw, 0x14, 0x8088);
	rtl_mdio_write(hw, 0x14, 0xa4ee);
	rtl_mdio_write(hw, 0x14, 0x8089);
	rtl_mdio_write(hw, 0x14, 0x44ee);
	rtl_mdio_write(hw, 0x14, 0x809a);
	rtl_mdio_write(hw, 0x14, 0xa4ee);
	rtl_mdio_write(hw, 0x14, 0x809b);
	rtl_mdio_write(hw, 0x14, 0x44ee);
	rtl_mdio_write(hw, 0x14, 0x809c);
	rtl_mdio_write(hw, 0x14, 0xa7ee);
	rtl_mdio_write(hw, 0x14, 0x80a5);
	rtl_mdio_write(hw, 0x14, 0xa7d2);
	rtl_mdio_write(hw, 0x14, 0x0002);
	rtl_mdio_write(hw, 0x14, 0x0e66);
	rtl_mdio_write(hw, 0x14, 0x0285);
	rtl_mdio_write(hw, 0x14, 0xc0ee);
	rtl_mdio_write(hw, 0x14, 0x87fc);
	rtl_mdio_write(hw, 0x14, 0x00e0);
	rtl_mdio_write(hw, 0x14, 0x8245);
	rtl_mdio_write(hw, 0x14, 0xf622);
	rtl_mdio_write(hw, 0x14, 0xe482);
	rtl_mdio_write(hw, 0x14, 0x45ef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xfdfc);
	rtl_mdio_write(hw, 0x14, 0x0402);
	rtl_mdio_write(hw, 0x14, 0x847a);
	rtl_mdio_write(hw, 0x14, 0x0284);
	rtl_mdio_write(hw, 0x14, 0xb302);
	rtl_mdio_write(hw, 0x14, 0x0cab);
	rtl_mdio_write(hw, 0x14, 0x020c);
	rtl_mdio_write(hw, 0x14, 0xc402);
	rtl_mdio_write(hw, 0x14, 0x0cef);
	rtl_mdio_write(hw, 0x14, 0x020d);
	rtl_mdio_write(hw, 0x14, 0x0802);
	rtl_mdio_write(hw, 0x14, 0x0d33);
	rtl_mdio_write(hw, 0x14, 0x020c);
	rtl_mdio_write(hw, 0x14, 0x3d04);
	rtl_mdio_write(hw, 0x14, 0xf8fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xe182);
	rtl_mdio_write(hw, 0x14, 0x2fac);
	rtl_mdio_write(hw, 0x14, 0x291a);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x24ac);
	rtl_mdio_write(hw, 0x14, 0x2102);
	rtl_mdio_write(hw, 0x14, 0xae22);
	rtl_mdio_write(hw, 0x14, 0x0210);
	rtl_mdio_write(hw, 0x14, 0x57f6);
	rtl_mdio_write(hw, 0x14, 0x21e4);
	rtl_mdio_write(hw, 0x14, 0x8224);
	rtl_mdio_write(hw, 0x14, 0xd101);
	rtl_mdio_write(hw, 0x14, 0xbf44);
	rtl_mdio_write(hw, 0x14, 0xd202);
	rtl_mdio_write(hw, 0x14, 0x4259);
	rtl_mdio_write(hw, 0x14, 0xae10);
	rtl_mdio_write(hw, 0x14, 0x0212);
	rtl_mdio_write(hw, 0x14, 0x4cf6);
	rtl_mdio_write(hw, 0x14, 0x29e5);
	rtl_mdio_write(hw, 0x14, 0x822f);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x24f6);
	rtl_mdio_write(hw, 0x14, 0x21e4);
	rtl_mdio_write(hw, 0x14, 0x8224);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefc);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xe182);
	rtl_mdio_write(hw, 0x14, 0x2fac);
	rtl_mdio_write(hw, 0x14, 0x2a18);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x24ac);
	rtl_mdio_write(hw, 0x14, 0x2202);
	rtl_mdio_write(hw, 0x14, 0xae26);
	rtl_mdio_write(hw, 0x14, 0x0284);
	rtl_mdio_write(hw, 0x14, 0xf802);
	rtl_mdio_write(hw, 0x14, 0x8565);
	rtl_mdio_write(hw, 0x14, 0xd101);
	rtl_mdio_write(hw, 0x14, 0xbf44);
	rtl_mdio_write(hw, 0x14, 0xd502);
	rtl_mdio_write(hw, 0x14, 0x4259);
	rtl_mdio_write(hw, 0x14, 0xae0e);
	rtl_mdio_write(hw, 0x14, 0x0284);
	rtl_mdio_write(hw, 0x14, 0xea02);
	rtl_mdio_write(hw, 0x14, 0x85a9);
	rtl_mdio_write(hw, 0x14, 0xe182);
	rtl_mdio_write(hw, 0x14, 0x2ff6);
	rtl_mdio_write(hw, 0x14, 0x2ae5);
	rtl_mdio_write(hw, 0x14, 0x822f);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x24f6);
	rtl_mdio_write(hw, 0x14, 0x22e4);
	rtl_mdio_write(hw, 0x14, 0x8224);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf9e2);
	rtl_mdio_write(hw, 0x14, 0x8011);
	rtl_mdio_write(hw, 0x14, 0xad31);
	rtl_mdio_write(hw, 0x14, 0x05d2);
	rtl_mdio_write(hw, 0x14, 0x0002);
	rtl_mdio_write(hw, 0x14, 0x0e66);
	rtl_mdio_write(hw, 0x14, 0xfd04);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xfaef);
	rtl_mdio_write(hw, 0x14, 0x69e0);
	rtl_mdio_write(hw, 0x14, 0x8011);
	rtl_mdio_write(hw, 0x14, 0xad21);
	rtl_mdio_write(hw, 0x14, 0x5cbf);
	rtl_mdio_write(hw, 0x14, 0x43be);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x97ac);
	rtl_mdio_write(hw, 0x14, 0x281b);
	rtl_mdio_write(hw, 0x14, 0xbf43);
	rtl_mdio_write(hw, 0x14, 0xc102);
	rtl_mdio_write(hw, 0x14, 0x4297);
	rtl_mdio_write(hw, 0x14, 0xac28);
	rtl_mdio_write(hw, 0x14, 0x12bf);
	rtl_mdio_write(hw, 0x14, 0x43c7);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x97ac);
	rtl_mdio_write(hw, 0x14, 0x2804);
	rtl_mdio_write(hw, 0x14, 0xd300);
	rtl_mdio_write(hw, 0x14, 0xae07);
	rtl_mdio_write(hw, 0x14, 0xd306);
	rtl_mdio_write(hw, 0x14, 0xaf85);
	rtl_mdio_write(hw, 0x14, 0x56d3);
	rtl_mdio_write(hw, 0x14, 0x03e0);
	rtl_mdio_write(hw, 0x14, 0x8011);
	rtl_mdio_write(hw, 0x14, 0xad26);
	rtl_mdio_write(hw, 0x14, 0x25bf);
	rtl_mdio_write(hw, 0x14, 0x4559);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x97e2);
	rtl_mdio_write(hw, 0x14, 0x8073);
	rtl_mdio_write(hw, 0x14, 0x0d21);
	rtl_mdio_write(hw, 0x14, 0xf637);
	rtl_mdio_write(hw, 0x14, 0x0d11);
	rtl_mdio_write(hw, 0x14, 0xf62f);
	rtl_mdio_write(hw, 0x14, 0x1b21);
	rtl_mdio_write(hw, 0x14, 0xaa02);
	rtl_mdio_write(hw, 0x14, 0xae10);
	rtl_mdio_write(hw, 0x14, 0xe280);
	rtl_mdio_write(hw, 0x14, 0x740d);
	rtl_mdio_write(hw, 0x14, 0x21f6);
	rtl_mdio_write(hw, 0x14, 0x371b);
	rtl_mdio_write(hw, 0x14, 0x21aa);
	rtl_mdio_write(hw, 0x14, 0x0313);
	rtl_mdio_write(hw, 0x14, 0xae02);
	rtl_mdio_write(hw, 0x14, 0x2b02);
	rtl_mdio_write(hw, 0x14, 0x020e);
	rtl_mdio_write(hw, 0x14, 0x5102);
	rtl_mdio_write(hw, 0x14, 0x0e66);
	rtl_mdio_write(hw, 0x14, 0x020f);
	rtl_mdio_write(hw, 0x14, 0xa3ef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xfdfc);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xf9fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xe080);
	rtl_mdio_write(hw, 0x14, 0x12ad);
	rtl_mdio_write(hw, 0x14, 0x2733);
	rtl_mdio_write(hw, 0x14, 0xbf43);
	rtl_mdio_write(hw, 0x14, 0xbe02);
	rtl_mdio_write(hw, 0x14, 0x4297);
	rtl_mdio_write(hw, 0x14, 0xac28);
	rtl_mdio_write(hw, 0x14, 0x09bf);
	rtl_mdio_write(hw, 0x14, 0x43c1);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x97ad);
	rtl_mdio_write(hw, 0x14, 0x2821);
	rtl_mdio_write(hw, 0x14, 0xbf45);
	rtl_mdio_write(hw, 0x14, 0x5902);
	rtl_mdio_write(hw, 0x14, 0x4297);
	rtl_mdio_write(hw, 0x14, 0xe387);
	rtl_mdio_write(hw, 0x14, 0xffd2);
	rtl_mdio_write(hw, 0x14, 0x001b);
	rtl_mdio_write(hw, 0x14, 0x45ac);
	rtl_mdio_write(hw, 0x14, 0x2711);
	rtl_mdio_write(hw, 0x14, 0xe187);
	rtl_mdio_write(hw, 0x14, 0xfebf);
	rtl_mdio_write(hw, 0x14, 0x87e4);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x590d);
	rtl_mdio_write(hw, 0x14, 0x11bf);
	rtl_mdio_write(hw, 0x14, 0x87e7);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59ef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xfdfc);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xfaef);
	rtl_mdio_write(hw, 0x14, 0x69d1);
	rtl_mdio_write(hw, 0x14, 0x00bf);
	rtl_mdio_write(hw, 0x14, 0x87e4);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59bf);
	rtl_mdio_write(hw, 0x14, 0x87e7);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59ef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xee87);
	rtl_mdio_write(hw, 0x14, 0xff46);
	rtl_mdio_write(hw, 0x14, 0xee87);
	rtl_mdio_write(hw, 0x14, 0xfe01);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xfaef);
	rtl_mdio_write(hw, 0x14, 0x69e0);
	rtl_mdio_write(hw, 0x14, 0x8241);
	rtl_mdio_write(hw, 0x14, 0xa000);
	rtl_mdio_write(hw, 0x14, 0x0502);
	rtl_mdio_write(hw, 0x14, 0x85eb);
	rtl_mdio_write(hw, 0x14, 0xae0e);
	rtl_mdio_write(hw, 0x14, 0xa001);
	rtl_mdio_write(hw, 0x14, 0x0502);
	rtl_mdio_write(hw, 0x14, 0x1a5a);
	rtl_mdio_write(hw, 0x14, 0xae06);
	rtl_mdio_write(hw, 0x14, 0xa002);
	rtl_mdio_write(hw, 0x14, 0x0302);
	rtl_mdio_write(hw, 0x14, 0x1ae6);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefc);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xf9fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x29f6);
	rtl_mdio_write(hw, 0x14, 0x21e4);
	rtl_mdio_write(hw, 0x14, 0x8229);
	rtl_mdio_write(hw, 0x14, 0xe080);
	rtl_mdio_write(hw, 0x14, 0x10ac);
	rtl_mdio_write(hw, 0x14, 0x2202);
	rtl_mdio_write(hw, 0x14, 0xae76);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x27f7);
	rtl_mdio_write(hw, 0x14, 0x21e4);
	rtl_mdio_write(hw, 0x14, 0x8227);
	rtl_mdio_write(hw, 0x14, 0xbf43);
	rtl_mdio_write(hw, 0x14, 0x1302);
	rtl_mdio_write(hw, 0x14, 0x4297);
	rtl_mdio_write(hw, 0x14, 0xef21);
	rtl_mdio_write(hw, 0x14, 0xbf43);
	rtl_mdio_write(hw, 0x14, 0x1602);
	rtl_mdio_write(hw, 0x14, 0x4297);
	rtl_mdio_write(hw, 0x14, 0x0c11);
	rtl_mdio_write(hw, 0x14, 0x1e21);
	rtl_mdio_write(hw, 0x14, 0xbf43);
	rtl_mdio_write(hw, 0x14, 0x1902);
	rtl_mdio_write(hw, 0x14, 0x4297);
	rtl_mdio_write(hw, 0x14, 0x0c12);
	rtl_mdio_write(hw, 0x14, 0x1e21);
	rtl_mdio_write(hw, 0x14, 0xe682);
	rtl_mdio_write(hw, 0x14, 0x43a2);
	rtl_mdio_write(hw, 0x14, 0x000a);
	rtl_mdio_write(hw, 0x14, 0xe182);
	rtl_mdio_write(hw, 0x14, 0x27f6);
	rtl_mdio_write(hw, 0x14, 0x29e5);
	rtl_mdio_write(hw, 0x14, 0x8227);
	rtl_mdio_write(hw, 0x14, 0xae42);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x44f7);
	rtl_mdio_write(hw, 0x14, 0x21e4);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0x0246);
	rtl_mdio_write(hw, 0x14, 0xaebf);
	rtl_mdio_write(hw, 0x14, 0x4325);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x97ef);
	rtl_mdio_write(hw, 0x14, 0x21bf);
	rtl_mdio_write(hw, 0x14, 0x431c);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x970c);
	rtl_mdio_write(hw, 0x14, 0x121e);
	rtl_mdio_write(hw, 0x14, 0x21bf);
	rtl_mdio_write(hw, 0x14, 0x431f);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x970c);
	rtl_mdio_write(hw, 0x14, 0x131e);
	rtl_mdio_write(hw, 0x14, 0x21bf);
	rtl_mdio_write(hw, 0x14, 0x4328);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x970c);
	rtl_mdio_write(hw, 0x14, 0x141e);
	rtl_mdio_write(hw, 0x14, 0x21bf);
	rtl_mdio_write(hw, 0x14, 0x44b1);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x970c);
	rtl_mdio_write(hw, 0x14, 0x161e);
	rtl_mdio_write(hw, 0x14, 0x21e6);
	rtl_mdio_write(hw, 0x14, 0x8242);
	rtl_mdio_write(hw, 0x14, 0xee82);
	rtl_mdio_write(hw, 0x14, 0x4101);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefd);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x46a0);
	rtl_mdio_write(hw, 0x14, 0x0005);
	rtl_mdio_write(hw, 0x14, 0x0286);
	rtl_mdio_write(hw, 0x14, 0x96ae);
	rtl_mdio_write(hw, 0x14, 0x06a0);
	rtl_mdio_write(hw, 0x14, 0x0103);
	rtl_mdio_write(hw, 0x14, 0x0219);
	rtl_mdio_write(hw, 0x14, 0x19ef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x29f6);
	rtl_mdio_write(hw, 0x14, 0x20e4);
	rtl_mdio_write(hw, 0x14, 0x8229);
	rtl_mdio_write(hw, 0x14, 0xe080);
	rtl_mdio_write(hw, 0x14, 0x10ac);
	rtl_mdio_write(hw, 0x14, 0x2102);
	rtl_mdio_write(hw, 0x14, 0xae54);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x27f7);
	rtl_mdio_write(hw, 0x14, 0x20e4);
	rtl_mdio_write(hw, 0x14, 0x8227);
	rtl_mdio_write(hw, 0x14, 0xbf42);
	rtl_mdio_write(hw, 0x14, 0xe602);
	rtl_mdio_write(hw, 0x14, 0x4297);
	rtl_mdio_write(hw, 0x14, 0xac28);
	rtl_mdio_write(hw, 0x14, 0x22bf);
	rtl_mdio_write(hw, 0x14, 0x430d);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x97e5);
	rtl_mdio_write(hw, 0x14, 0x8247);
	rtl_mdio_write(hw, 0x14, 0xac28);
	rtl_mdio_write(hw, 0x14, 0x20d1);
	rtl_mdio_write(hw, 0x14, 0x03bf);
	rtl_mdio_write(hw, 0x14, 0x4307);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59ee);
	rtl_mdio_write(hw, 0x14, 0x8246);
	rtl_mdio_write(hw, 0x14, 0x00e1);
	rtl_mdio_write(hw, 0x14, 0x8227);
	rtl_mdio_write(hw, 0x14, 0xf628);
	rtl_mdio_write(hw, 0x14, 0xe582);
	rtl_mdio_write(hw, 0x14, 0x27ae);
	rtl_mdio_write(hw, 0x14, 0x21d1);
	rtl_mdio_write(hw, 0x14, 0x04bf);
	rtl_mdio_write(hw, 0x14, 0x4307);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59ae);
	rtl_mdio_write(hw, 0x14, 0x08d1);
	rtl_mdio_write(hw, 0x14, 0x05bf);
	rtl_mdio_write(hw, 0x14, 0x4307);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59e0);
	rtl_mdio_write(hw, 0x14, 0x8244);
	rtl_mdio_write(hw, 0x14, 0xf720);
	rtl_mdio_write(hw, 0x14, 0xe482);
	rtl_mdio_write(hw, 0x14, 0x4402);
	rtl_mdio_write(hw, 0x14, 0x46ae);
	rtl_mdio_write(hw, 0x14, 0xee82);
	rtl_mdio_write(hw, 0x14, 0x4601);
	rtl_mdio_write(hw, 0x14, 0xef96);
	rtl_mdio_write(hw, 0x14, 0xfefc);
	rtl_mdio_write(hw, 0x14, 0x04f8);
	rtl_mdio_write(hw, 0x14, 0xfaef);
	rtl_mdio_write(hw, 0x14, 0x69e0);
	rtl_mdio_write(hw, 0x14, 0x8013);
	rtl_mdio_write(hw, 0x14, 0xad24);
	rtl_mdio_write(hw, 0x14, 0x1cbf);
	rtl_mdio_write(hw, 0x14, 0x87f0);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x97ad);
	rtl_mdio_write(hw, 0x14, 0x2813);
	rtl_mdio_write(hw, 0x14, 0xe087);
	rtl_mdio_write(hw, 0x14, 0xfca0);
	rtl_mdio_write(hw, 0x14, 0x0005);
	rtl_mdio_write(hw, 0x14, 0x0287);
	rtl_mdio_write(hw, 0x14, 0x36ae);
	rtl_mdio_write(hw, 0x14, 0x10a0);
	rtl_mdio_write(hw, 0x14, 0x0105);
	rtl_mdio_write(hw, 0x14, 0x0287);
	rtl_mdio_write(hw, 0x14, 0x48ae);
	rtl_mdio_write(hw, 0x14, 0x08e0);
	rtl_mdio_write(hw, 0x14, 0x8230);
	rtl_mdio_write(hw, 0x14, 0xf626);
	rtl_mdio_write(hw, 0x14, 0xe482);
	rtl_mdio_write(hw, 0x14, 0x30ef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8e0);
	rtl_mdio_write(hw, 0x14, 0x8245);
	rtl_mdio_write(hw, 0x14, 0xf722);
	rtl_mdio_write(hw, 0x14, 0xe482);
	rtl_mdio_write(hw, 0x14, 0x4502);
	rtl_mdio_write(hw, 0x14, 0x46ae);
	rtl_mdio_write(hw, 0x14, 0xee87);
	rtl_mdio_write(hw, 0x14, 0xfc01);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8fa);
	rtl_mdio_write(hw, 0x14, 0xef69);
	rtl_mdio_write(hw, 0x14, 0xfb02);
	rtl_mdio_write(hw, 0x14, 0x46d3);
	rtl_mdio_write(hw, 0x14, 0xad50);
	rtl_mdio_write(hw, 0x14, 0x2fbf);
	rtl_mdio_write(hw, 0x14, 0x87ed);
	rtl_mdio_write(hw, 0x14, 0xd101);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59bf);
	rtl_mdio_write(hw, 0x14, 0x87ed);
	rtl_mdio_write(hw, 0x14, 0xd100);
	rtl_mdio_write(hw, 0x14, 0x0242);
	rtl_mdio_write(hw, 0x14, 0x59e0);
	rtl_mdio_write(hw, 0x14, 0x8245);
	rtl_mdio_write(hw, 0x14, 0xf622);
	rtl_mdio_write(hw, 0x14, 0xe482);
	rtl_mdio_write(hw, 0x14, 0x4502);
	rtl_mdio_write(hw, 0x14, 0x46ae);
	rtl_mdio_write(hw, 0x14, 0xd100);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0xf002);
	rtl_mdio_write(hw, 0x14, 0x4259);
	rtl_mdio_write(hw, 0x14, 0xee87);
	rtl_mdio_write(hw, 0x14, 0xfc00);
	rtl_mdio_write(hw, 0x14, 0xe082);
	rtl_mdio_write(hw, 0x14, 0x30f6);
	rtl_mdio_write(hw, 0x14, 0x26e4);
	rtl_mdio_write(hw, 0x14, 0x8230);
	rtl_mdio_write(hw, 0x14, 0xffef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xfc04);
	rtl_mdio_write(hw, 0x14, 0xf8f9);
	rtl_mdio_write(hw, 0x14, 0xface);
	rtl_mdio_write(hw, 0x14, 0xfaef);
	rtl_mdio_write(hw, 0x14, 0x69fb);
	rtl_mdio_write(hw, 0x14, 0xbf87);
	rtl_mdio_write(hw, 0x14, 0xb3d7);
	rtl_mdio_write(hw, 0x14, 0x001c);
	rtl_mdio_write(hw, 0x14, 0xd819);
	rtl_mdio_write(hw, 0x14, 0xd919);
	rtl_mdio_write(hw, 0x14, 0xda19);
	rtl_mdio_write(hw, 0x14, 0xdb19);
	rtl_mdio_write(hw, 0x14, 0x07ef);
	rtl_mdio_write(hw, 0x14, 0x9502);
	rtl_mdio_write(hw, 0x14, 0x4259);
	rtl_mdio_write(hw, 0x14, 0x073f);
	rtl_mdio_write(hw, 0x14, 0x0004);
	rtl_mdio_write(hw, 0x14, 0x9fec);
	rtl_mdio_write(hw, 0x14, 0xffef);
	rtl_mdio_write(hw, 0x14, 0x96fe);
	rtl_mdio_write(hw, 0x14, 0xc6fe);
	rtl_mdio_write(hw, 0x14, 0xfdfc);
	rtl_mdio_write(hw, 0x14, 0x0400);
	rtl_mdio_write(hw, 0x14, 0x0145);
	rtl_mdio_write(hw, 0x14, 0x7d00);
	rtl_mdio_write(hw, 0x14, 0x0345);
	rtl_mdio_write(hw, 0x14, 0x5c00);
	rtl_mdio_write(hw, 0x14, 0x0143);
	rtl_mdio_write(hw, 0x14, 0x4f00);
	rtl_mdio_write(hw, 0x14, 0x0387);
	rtl_mdio_write(hw, 0x14, 0xdb00);
	rtl_mdio_write(hw, 0x14, 0x0987);
	rtl_mdio_write(hw, 0x14, 0xde00);
	rtl_mdio_write(hw, 0x14, 0x0987);
	rtl_mdio_write(hw, 0x14, 0xe100);
	rtl_mdio_write(hw, 0x14, 0x0087);
	rtl_mdio_write(hw, 0x14, 0xeaa4);
	rtl_mdio_write(hw, 0x14, 0x00b8);
	rtl_mdio_write(hw, 0x14, 0x20c4);
	rtl_mdio_write(hw, 0x14, 0x1600);
	rtl_mdio_write(hw, 0x14, 0x000f);
	rtl_mdio_write(hw, 0x14, 0xf800);
	rtl_mdio_write(hw, 0x14, 0x7098);
	rtl_mdio_write(hw, 0x14, 0xa58a);
	rtl_mdio_write(hw, 0x14, 0xb6a8);
	rtl_mdio_write(hw, 0x14, 0x3e50);
	rtl_mdio_write(hw, 0x14, 0xa83e);
	rtl_mdio_write(hw, 0x14, 0x33bc);
	rtl_mdio_write(hw, 0x14, 0xc622);
	rtl_mdio_write(hw, 0x14, 0xbcc6);
	rtl_mdio_write(hw, 0x14, 0xaaa4);
	rtl_mdio_write(hw, 0x14, 0x42ff);
	rtl_mdio_write(hw, 0x14, 0xc408);
	rtl_mdio_write(hw, 0x14, 0x00c4);
	rtl_mdio_write(hw, 0x14, 0x16a8);
	rtl_mdio_write(hw, 0x14, 0xbcc0);
	rtl_mdio_write(hw, 0x13, 0xb818);
	rtl_mdio_write(hw, 0x14, 0x02f3);
	rtl_mdio_write(hw, 0x13, 0xb81a);
	rtl_mdio_write(hw, 0x14, 0x17d1);
	rtl_mdio_write(hw, 0x13, 0xb81c);
	rtl_mdio_write(hw, 0x14, 0x185a);
	rtl_mdio_write(hw, 0x13, 0xb81e);
	rtl_mdio_write(hw, 0x14, 0x3c66);
	rtl_mdio_write(hw, 0x13, 0xb820);
	rtl_mdio_write(hw, 0x14, 0x021f);
	rtl_mdio_write(hw, 0x13, 0xc416);
	rtl_mdio_write(hw, 0x14, 0x0500);
	rtl_mdio_write(hw, 0x13, 0xb82e);
	rtl_mdio_write(hw, 0x14, 0xfffc);

	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x0000);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x1f, 0x0B82);
	gphy_val = rtl_mdio_read(hw, 0x10);
	gphy_val &= ~BIT_9;
	rtl_mdio_write(hw, 0x10, gphy_val);
	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8146);
	rtl_mdio_write(hw, 0x14, 0x0000);

	rtl_clear_phy_mcu_patch_request(hw);
}

/* ------------------------------------PHY 8168GU2------------------------------------- */

static void
rtl8168_set_phy_mcu_8168gu_2(struct rtl_hw *hw)
{
	unsigned int gphy_val;

	rtl_set_phy_mcu_patch_request(hw);
	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8146);
	rtl_mdio_write(hw, 0x14, 0x0300);
	rtl_mdio_write(hw, 0x13, 0xB82E);
	rtl_mdio_write(hw, 0x14, 0x0001);
	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0xb820);
	rtl_mdio_write(hw, 0x14, 0x0290);
	rtl_mdio_write(hw, 0x13, 0xa012);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xa014);
	rtl_mdio_write(hw, 0x14, 0x2c04);
	rtl_mdio_write(hw, 0x14, 0x2c07);
	rtl_mdio_write(hw, 0x14, 0x2c07);
	rtl_mdio_write(hw, 0x14, 0x2c07);
	rtl_mdio_write(hw, 0x14, 0xa304);
	rtl_mdio_write(hw, 0x14, 0xa301);
	rtl_mdio_write(hw, 0x14, 0x207e);
	rtl_mdio_write(hw, 0x13, 0xa01a);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x13, 0xa006);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xa004);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xa002);
	rtl_mdio_write(hw, 0x14, 0x0fff);
	rtl_mdio_write(hw, 0x13, 0xa000);
	rtl_mdio_write(hw, 0x14, 0x107c);
	rtl_mdio_write(hw, 0x13, 0xb820);
	rtl_mdio_write(hw, 0x14, 0x0210);
	rtl_mdio_write(hw, 0x1F, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x0000);
	rtl_mdio_write(hw, 0x14, 0x0000);
	rtl_mdio_write(hw, 0x1f, 0x0B82);
	gphy_val = rtl_mdio_read(hw, 0x17);
	gphy_val &= ~BIT_0;
	rtl_mdio_write(hw, 0x17, gphy_val);
	rtl_mdio_write(hw, 0x1f, 0x0A43);
	rtl_mdio_write(hw, 0x13, 0x8146);
	rtl_mdio_write(hw, 0x14, 0x0000);

	rtl_clear_phy_mcu_patch_request(hw);
}

void
hw_mac_mcu_config_8168g(struct rtl_hw *hw)
{
	if (hw->NotWrMcuPatchCode)
		return;

	switch (hw->mcfg) {
	case CFG_METHOD_21:
		rtl8168_set_mac_mcu_8168g_1(hw);
		break;
	case CFG_METHOD_24:
		rtl8168_set_mac_mcu_8168gu_1(hw);
		break;
	case CFG_METHOD_25:
		rtl8168_set_mac_mcu_8168gu_2(hw);
		break;
	}
}

void
hw_phy_mcu_config_8168g(struct rtl_hw *hw)
{
	switch (hw->mcfg) {
	case CFG_METHOD_21:
		rtl8168_set_phy_mcu_8168g_1(hw);
		break;
	case CFG_METHOD_25:
		rtl8168_set_phy_mcu_8168gu_2(hw);
		break;
	}
}
