//
// MonoTests.Mono.Math.ModRingTest.cs
//
// Authors:
//	Ben Maurer
//
// Copyright (c) 2003 Ben Maurer. All rights reserved
//

using System;
using Mono.Math;
using NUnit.Framework;

namespace MonoTests.Mono.Math {

	public abstract class ModRing_Base : BigIntegerTestSet {

		BigInteger A, B, N, abModN, aPowBmodN;
		BigInteger.ModulusRing mr;

		public ModRing_Base() 
		{
			A = new BigInteger( a );
			B = new BigInteger( b );
			N = new BigInteger( n );
			abModN = new BigInteger( ExpectedABmodN );
			aPowBmodN = new BigInteger( ExpectedApowBmodN );

			mr = new BigInteger.ModulusRing(N);
		}

		public abstract uint[] a {
			get;
		}

		public abstract uint[] b {
			get;
		}

		public abstract uint[] n {
			get;
		}

		public abstract uint[] ExpectedABmodN {
			get;
		}

		public abstract uint[] ExpectedApowBmodN {
			get;
		}

		[Test]
		public void ABmodN() 
		{
			Expect( mr.Multiply(A, B), abModN);
		}

		[Test]
		public void ApowBmodN() 
		{
			Expect( mr.Pow(A, B), aPowBmodN);
		}
	}
	
	public class ModRing_Rand1024a1024b2048nOdd : ModRing_Base{

		public override uint[] a {
			get {
				return new uint[] {
					0xe7dd698d, 0xb29fbd74, 0xf9d6504c, 0x9875efcc, 0x37c7e11e, 0xd6b49a39,
					0xf358bf6a, 0xf66ff164, 0x011e8cf8, 0x756f02ea, 0x8258c9d9, 0x14f566ee,
					0x8cd5427c, 0x311b9037, 0x0045a8a0, 0x8ceee3e2, 0x87f37f6b, 0xeba130f1,
					0xbed36adc, 0x0a0d0a34, 0x2ace5d20, 0x3e5e5393, 0x16847736, 0x9d71fe94,
					0x353d1e5e, 0x5056ff88, 0x9df1f588, 0xf404f30e, 0x1391db60, 0xb551b368,
					0x2eea74a5, 0x05aa7aef
				};
			}
		}

		public override uint[] b {
			get {
				return new uint[] {
					0xa94a2eb1, 0x08f1b111, 0xcb1dfc2c, 0x8197cd4d, 0x078e9b48, 0xf539268f,
					0xe300b44f, 0x994fc57a, 0x8b488ed0, 0xb6c0f8c9, 0xf5d36ee3, 0x7b4af3dd,
					0x46af6309, 0xa17c2c9d, 0x41310c40, 0x75f28379, 0xb5c9b4b3, 0xe9634432,
					0x900f917a, 0x5c2fc131, 0xc14b1387, 0x9853c0f7, 0xf276e3dc, 0xc2e14e9f,
					0x13c008df, 0x4171efb6, 0x325d48f8, 0x98518ea1, 0x71356152, 0xa6c8c7f5,
					0xffefa41d, 0x89683cb4
				};
			}
		}

		public override uint[] n {
			get {
				return new uint[] {
					0xaf2de4c4, 0x85a4e11f, 0x4809ca28, 0xe156a2b1, 0xb52d97f7, 0xff2cee7b,
					0x660b4439, 0x4039ec7c, 0x16bf69fc, 0x4ed45adb, 0xf3ee5bc3, 0xbfe46a9f,
					0x14de7170, 0xf9e4bbae, 0xfce5fe91, 0x59601691, 0x29fb72d8, 0x0fd182ae,
					0x8bf8459e, 0xcc5a537b, 0x1abeca20, 0x1c2e59c6, 0x46f4c198, 0x582c6666,
					0xf5d12eae, 0x45d542e9, 0x5a57822e, 0x7de9b713, 0x17cd4fb6, 0xc868e37d,
					0x86ac0aa5, 0x4c2c685e, 0x70614dd0, 0xca597a77, 0xf8efb06f, 0x7da2b9f5,
					0x94464cb0, 0x2370dc4c, 0xbf4d9da5, 0x66eac088, 0xe239b5d1, 0x4ce60b62,
					0x57833606, 0x07da14b7, 0x3b050fa5, 0xd45ee2e6, 0x5cce4ce8, 0xdaa576a9,
					0xf33b93ea, 0x2432e269, 0x41b8e9e7, 0x467971cc, 0xf64048f1, 0xa1c5511f,
					0x739a7a6a, 0x9176893b, 0x76a6ba9d, 0x9c81dee7, 0xefb4663c, 0x4d592637,
					0x72aac960, 0xf6303ef8, 0x15d53cfa, 0x5e569e75
				};
			}
		}

		public override uint[] ExpectedABmodN {
			get {
				return new uint[] {
					0x99545af9, 0x2f085a6d, 0x30dc921f, 0xecf427c5, 0x63fb5151, 0x59ccf52a,
					0x33e71589, 0xecc1d8d3, 0xde663b45, 0xc4e8ab10, 0x847bd821, 0x9c9f4389,
					0xb17be974, 0x09477b93, 0x3cd3a919, 0x09aedbb6, 0xc8e51d3b, 0xfead592b,
					0x7ea91f0d, 0xe98b3cdb, 0x547a4fda, 0x23ed43a8, 0xa56e90d3, 0xefeca348,
					0x16e7d5e5, 0x9f3ec6f6, 0x6f5fec12, 0xf793af3f, 0x1aa7f24e, 0xefc15497,
					0x76e65728, 0xab133454, 0x55a159cc, 0x6927c6d0, 0xd82c8b4e, 0x98e0e0e3,
					0xdd9367c0, 0x869aede1, 0x59bd88ea, 0x99be753b, 0xee952b5f, 0x26eabce8,
					0x15e9e55b, 0x0f4381cf, 0x11beff16, 0x21b9269e, 0xdce0f488, 0x076bf6d6,
					0x279feaa7, 0x8396508a, 0x3a9c73ab, 0x8f971790, 0x7ce19707, 0x672b0f7d,
					0x5ff6cdd4, 0x5a1dc8ed, 0x867744a9, 0x7d278a50, 0x25c2c19f, 0x590d3c16,
					0x9dcc866c, 0x075a9096, 0x5475437a, 0xc8c6740c
				};
			}
		}

		public override uint[] ExpectedApowBmodN {
			get {
				return new uint[] {
					0x95ea659f, 0xc7c2f3ec, 0xfde6c863, 0x6661bb0e, 0xf15b3377, 0x9c493fa5,
					0xe4271fac, 0x7c6a859e, 0x2734cb47, 0x48f62ed5, 0x6a3f8bb6, 0x59adb336,
					0xf76b177c, 0xedc670b2, 0x24a8f9ad, 0xa177c5f5, 0x09135890, 0xce6db202,
					0x02dd1ef5, 0x6af709e9, 0xe69eba8e, 0xab427407, 0x697deec9, 0x594f8c57,
					0xc3ac59c3, 0x2d53ec01, 0x45055bea, 0x8f6c5484, 0xd54c9404, 0x33090f9f,
					0xef66e6f6, 0x2e64624d, 0x7b5b843e, 0x721581f6, 0x7564d873, 0x707300bd,
					0xb55a5886, 0x3f078302, 0x9fa17d7f, 0x995882f1, 0x550732f9, 0x8203f6ea,
					0xde01a745, 0xbdf8aae2, 0x8e2ba50e, 0xbcbc8e3d, 0xe0ecd850, 0xb3f2fbf0,
					0x97891005, 0xac7ba64b, 0x48ab0d31, 0x0ecf7ccb, 0x3e89a36c, 0xdb75c7e2,
					0x93247673, 0x8f1d473c, 0xdbbaba0c, 0x63fe2c19, 0xaab9267f, 0xa7d1d37a,
					0x0fbcc508, 0x5ff6a55f, 0xa329fc9a, 0xb90a7699
				};
			}
		}
	}	

	public class ModRing_Rand1024a1024b2048nEven : ModRing_Base{

		public override uint[] a {
			get {
				return new uint[] {
					0xbe6e4c8b, 0xea8c02d1, 0x216a6e05, 0x51c7d14b, 0xa3b9d0cf, 0xd143585c,
					0x70ef2713, 0x68711238, 0xb3b20c44, 0xd0aabeec, 0xcaad4b5c, 0x82012cba,
					0x3502391f, 0x2fc35799, 0x6f97cccf, 0x8a2e0bba, 0x136cf66a, 0x46963185,
					0x6662b18d, 0xa696183d, 0xbc30c60c, 0x0fb6ceae, 0x72ee7318, 0x24266a3e,
					0x02271be8, 0x0ff30a9d, 0xa5daf390, 0x75fbfc7d, 0xeebc96f7, 0x8d1fc7a5,
					0xaf00db95, 0x59677478
				};
			}
		}

		public override uint[] b {
			get {
				return new uint[] {
					0xb6981b96, 0x98eaa819, 0x07f5510b, 0x4f0b646d, 0xb71114ac, 0x92beafab,
					0x39e157d0, 0x63671e3c, 0x59b77fd9, 0x3e638dad, 0xd470b605, 0x08673d3b,
					0xc5c3b3c9, 0x7275c772, 0x1085754d, 0x1c57ecc2, 0xd25dcefa, 0x5ba37917,
					0x7c32ae77, 0xce6c14da, 0x89440b79, 0xac0e387e, 0x3d7754a0, 0x181bb607,
					0xfea83dcc, 0xf1df9e10, 0x411d84c5, 0xfd1474a4, 0xcbb3d64c, 0xafe2fbfe,
					0xdf2dcbea, 0x13a2bbba
				};
			}
		}

		public override uint[] n {
			get {
				return new uint[] {
					0x94252210, 0x350974a7, 0xbf7a0dd4, 0x110a809b, 0xad8ffa3e, 0xf6ec2efb,
					0xbfead542, 0x0df626e2, 0x4e41faa7, 0x5b1953e1, 0xe52da5b0, 0xa4218a89,
					0xbf7815eb, 0x1a8dec38, 0xf20915f8, 0x4182d03d, 0x59e2d808, 0x55d42b95,
					0xc4ebccd7, 0x3876bf30, 0xe16cb40d, 0x9ec840bb, 0x26f3b349, 0x1f8c603f,
					0xb4f8475d, 0x8f98c5fc, 0x18feac88, 0xa8cf1b83, 0x83522467, 0xa3aedd50,
					0x4cd8c67e, 0xe2d40264, 0x990e2bcc, 0x11796b18, 0xb1294fc4, 0x2ac464ef,
					0x5c35361e, 0x2668d7b4, 0x6bab6a71, 0xb8236f83, 0xa8647bea, 0xff0fd44f,
					0x1e070b1c, 0xf35d54b9, 0x24d2f650, 0x1dea3c82, 0x9ec28e29, 0x1fea7251,
					0xa4ac226b, 0x1fd19f99, 0xa0eedc2f, 0x7dd6f42e, 0x5ef07907, 0x33d3ea4b,
					0x5bedef17, 0xe830ad3c, 0x8049b097, 0x461c3316, 0xec357169, 0x56c8f310,
					0xdc07c91d, 0xddbb079c, 0xbc22e5d2, 0x203f07ba
				};
			}
		}

		public override uint[] ExpectedABmodN {
			get {
				return new uint[] {
					0x87d3906e, 0x9446742a, 0x985787a5, 0xd6dc4380, 0xd3e0d265, 0x73348ad1,
					0xf481daef, 0xc8d21bad, 0x7704c02e, 0x177040a3, 0xe0609019, 0x58a79266,
					0xda422341, 0xc4887148, 0x702e8e66, 0x0627ba89, 0xd61be4f4, 0x90cf987d,
					0xa5fdaa93, 0xe5de5cf9, 0xfd14a43e, 0x438cbc9e, 0xcbc3da8d, 0xf6cd1de5,
					0x82c6457c, 0xaff73675, 0x99dfb897, 0x85ff4893, 0xe39dda4b, 0x179c0c7d,
					0x069f31be, 0x98f3a7c7, 0x57b3fb03, 0x184cde90, 0xbc1f1f90, 0xb3d49226,
					0xbf85ff85, 0x6a5d7184, 0xdf38f2fe, 0x75c4bc99, 0x00586230, 0x17f55862,
					0x7ea6ec51, 0x82bcd677, 0x46f092c9, 0xf4db0bd8, 0x634e93f3, 0x060470d8,
					0xeaebfdb0, 0x6fdf9047, 0x9b696501, 0x11cd6522, 0x6f4208e5, 0xb0e14845,
					0x934667dd, 0x3b817626, 0xd77cf088, 0xd6180636, 0xd13f74dc, 0x09367c98,
					0xc77265ef, 0xb794152a, 0x942e819e, 0x232e4730
				};
			}
		}

		public override uint[] ExpectedApowBmodN {
			get {
				return new uint[] {
					0x6c6035df, 0xb9995733, 0xbdc1c819, 0xb0376674, 0x99651ff2, 0x391cfb9a,
					0x894edd70, 0x2a724e6e, 0x32e37a64, 0xce626fef, 0x4efc6b73, 0x08cf4dc2,
					0xc36f5869, 0x757ca79e, 0x499625f5, 0x17b7e371, 0x6df98cf9, 0x33f70af4,
					0xfe71632d, 0xa43d0619, 0xd3746cc8, 0x9d60696d, 0xa04cfd7a, 0x3c515796,
					0xcb1df2c0, 0xf0ff0786, 0xba0307e1, 0xf5271947, 0xa3788c94, 0xd78b7619,
					0x1840903f, 0x4759f7ac, 0xe823e099, 0x927367bc, 0x058c68ea, 0x8ed2c616,
					0xdf36f218, 0x3e17c87b, 0x9725d13b, 0x904b8e4c, 0x7d11c14f, 0xe9b53d05,
					0x894cea7e, 0xca332b2a, 0x48a62c7f, 0xcc087b3b, 0xecc6ce98, 0x009c6bbb,
					0x586b702c, 0xe6738098, 0xa3eeeb68, 0x7dddb982, 0x280d567b, 0xfefcaa5f,
					0x4cc09854, 0x0cf93b87, 0x180f0451, 0x72d3c965, 0x7b766804, 0x612aa97b,
					0x0dec6df2, 0x395430ac, 0xa9938d82, 0x2abd9826
				};
			}
		}
	}	

	public class ModRing_Rand512a1024b2048nOdd : ModRing_Base{

		public override uint[] a {
			get {
				return new uint[] {
					0xadbbfe63, 0xf0f0614b, 0x917f0c06, 0x4b9c430c, 0xa7319760, 0xdfeb8648,
					0x979d2590, 0x4d447eaf, 0xe789b3fa, 0x82c58440, 0xaf51ebf7, 0xff07b1e6,
					0x42427273, 0xa8f71d70, 0x15bf33ac, 0x162d5d91
				};
			}
		}

		public override uint[] b {
			get {
				return new uint[] {
					0xf990b4d1, 0x4cf78f3e, 0x1a6d60e0, 0xe5d3d7f5, 0x85619389, 0xdd182d1f,
					0x196bbf7a, 0x06a44941, 0x4b856c46, 0x37b04502, 0x7d887dc1, 0x762c9e68,
					0x7a3d4f8f, 0xbfad2375, 0x98050232, 0x85bf4afa, 0x4e80b6ea, 0x121da8b1,
					0xea70fd5a, 0x2af4dc92, 0xba42b63b, 0x8d337a97, 0x179ad080, 0x0628b0a3,
					0xabe6c7a0, 0x48bb0424, 0x1b4aeabf, 0x83664f4c, 0x69f1ba62, 0x4717aab1,
					0xc601e331, 0x50208435
				};
			}
		}

		public override uint[] n {
			get {
				return new uint[] {
					0x87217f14, 0xac43bee1, 0x8fdca4d5, 0xa3d803e2, 0x4e75aa84, 0x378539ba,
					0x84db3df1, 0x8ba4b367, 0x2a13253a, 0x4348864b, 0xe4632bf6, 0x1a8bf3f3,
					0xfeef453f, 0x9f99f52a, 0x71e2c33a, 0x71780004, 0x06eff582, 0x4b21e5a8,
					0x03f1f040, 0x65bafbed, 0x1819cab5, 0x27213b3c, 0x6bc3452f, 0x9a24fd04,
					0xb1e28413, 0x1ade9bfc, 0xecb3efa9, 0x1fdfc38a, 0xf850ebfb, 0xeff26f83,
					0x08cff383, 0x2778deb3, 0x4c1eca0e, 0x26ca30db, 0xbff2001b, 0xf5e198fa,
					0xdd8d2318, 0xf47c21b2, 0x5849dc0e, 0x10662f2d, 0x3c6b7dea, 0x418df0f8,
					0x0ac64389, 0x73330ab8, 0x693e9f69, 0xd7366ace, 0x5274e008, 0x94108dff,
					0x89a4bc07, 0xbe565242, 0x8811a589, 0x44c1081a, 0x603aa596, 0xa4d1aecc,
					0xc498d9f3, 0xcabb3f02, 0x9b99c3a0, 0xc5fa25d9, 0xc707ee28, 0xd48b158d,
					0x2c10ca89, 0x000abe22, 0x24f8fdc1, 0xed01c7f9
				};
			}
		}

		public override uint[] ExpectedABmodN {
			get {
				return new uint[] {
					0xa95e0ee4, 0x87261bf8, 0x3a349263, 0x86d1a43d, 0xf237e922, 0x955c9563,
					0x041aa2ba, 0x9eca5eb9, 0x32221184, 0x9b4c9009, 0x3fcee1bb, 0x1bfcbd51,
					0x50dccf4b, 0xeb0a848b, 0x509c9c51, 0x9d015231, 0xbf975095, 0x671b9584,
					0x475df8da, 0xadc38a64, 0x098d8f1a, 0xab3cd079, 0xe3135c10, 0x122fb2d6,
					0x1a4c0577, 0x7b1181f2, 0xcbdb83ff, 0x15c282ae, 0x603be3d2, 0x26ccf8c6,
					0x20308c1b, 0xcd890826, 0x8ee34e0e, 0xf2a52bd0, 0x34bfc32a, 0x36d5a20f,
					0xd0fb641e, 0x79dc78b5, 0x7ff6eab7, 0xb80dc96b, 0xa5798d77, 0x3f5b2050,
					0xa039fc83, 0xa79c722c, 0x14aa69d9, 0x30e9fede, 0x4fe2dcb9, 0xfdc32305
				};
			}
		}

		public override uint[] ExpectedApowBmodN {
			get {
				return new uint[] {
					0x6add04a8, 0xa7ee1af7, 0xcfcd8284, 0x3a4b577f, 0xe859d060, 0x4f50b2ac,
					0xb43c2a9f, 0x33fbf042, 0x1833fc4b, 0xa599c5bd, 0xb74a8543, 0x1a81462c,
					0x14f292b9, 0xf404df6e, 0x19df42fb, 0x321afef8, 0xd93edf31, 0x0041228f,
					0xde4d0ab8, 0x8176e8b6, 0x9f5962cc, 0xab77a55c, 0x234ac84e, 0x7e4f20de,
					0x0b2f8a64, 0xf4e0ec07, 0x52c4ed70, 0x29573e9e, 0x222719ea, 0x5e469f08,
					0xa9f30eff, 0x0b0ea811, 0x0d507f0e, 0xbe890968, 0x9940114f, 0x4603c75c,
					0x37dd29ec, 0xa25f1ead, 0xf020b958, 0xda5d9da0, 0xe7748ed9, 0x7e2a5099,
					0x550fdb45, 0x0215e4b0, 0xafe277cd, 0x70474a6b, 0xbcb786dd, 0x99f53c4e,
					0x752ea936, 0xbc220371, 0xfd18694c, 0x8702fc69, 0x8314f272, 0xcc6d33f5,
					0xa1ab34f7, 0x3af30b59, 0x1f92dff5, 0xfcc4407f, 0xa4c0b239, 0x992192f2,
					0x06557c9b, 0x7a0f28bc, 0x02473839, 0xe82bbcc1
				};
			}
		}
	}	

	public class ModRing_Rand512a1024b2048nEven : ModRing_Base{

		public override uint[] a {
			get {
				return new uint[] {
					0xabb069bf, 0x94b85c92, 0x96917e78, 0x47d259e5, 0x8294e82a, 0xf2e05e35,
					0xf4836c3a, 0x3c9209e9, 0x511c1c4e, 0xf9c81b42, 0xf468abdc, 0x7b78923d,
					0x34b5ebe0, 0x9275ecc8, 0x474faa18, 0xb3497e65
				};
			}
		}

		public override uint[] b {
			get {
				return new uint[] {
					0xb8f411fd, 0x685ab5ad, 0xf1f753bc, 0xe1bb119d, 0x7a88efe0, 0x0e0af346,
					0xe5dbfd6c, 0xa0661af4, 0xda49b185, 0x695b7750, 0xcdae04a7, 0xf18ea18e,
					0x8a0b8a5b, 0x0b26f78f, 0x46a20e34, 0xd05ebdd4, 0x7787f342, 0x48eea674,
					0x70be1526, 0x5e8714d5, 0x817aa1ec, 0x79f1a047, 0x510369e6, 0x6e08477d,
					0x306ecc1f, 0x584442d8, 0xbbf2cc6a, 0x53bb8e03, 0x3c8b7d3e, 0xd99390f4,
					0xcb76abff, 0x9c9235fa
				};
			}
		}

		public override uint[] n {
			get {
				return new uint[] {
					0xf3ca50dd, 0x2d180ce1, 0x1e080c76, 0x77cf5168, 0xa58d8912, 0x74e1846a,
					0xe7b184ec, 0x23a6b38f, 0x509bdea2, 0xeb95d781, 0x71833a0e, 0x6acf10e5,
					0x7bbc8a42, 0xa9e40e47, 0x295ad5fd, 0x79122a0e, 0xc2e4e226, 0x358c0bdb,
					0x05e10780, 0x1af8d9a2, 0xad2aff45, 0x61bf61d0, 0x94baa086, 0x5fd07916,
					0x4c3da045, 0x3679bec9, 0x7bd4b5b8, 0x1670a617, 0x3444c644, 0xf36b4ab8,
					0x8ab60190, 0xbb364220, 0x8a6928a6, 0x581f0892, 0x915ad9d9, 0xecc1e429,
					0x898d886c, 0x85ae8c25, 0xd44df788, 0x22b67bac, 0xdcc9d273, 0x984acb99,
					0x24e04032, 0x87c3db0a, 0x401d502a, 0xb5e21450, 0x23e49b86, 0x4b0175d3,
					0x88f66369, 0x76c3969b, 0x7da83fee, 0x3377cdc8, 0x5fa35f77, 0xd5e9d9d2,
					0x5e9abe27, 0x063f3a9f, 0xb48a6982, 0xa6f9154b, 0xe7f426f0, 0xa0bc9b7d,
					0xb11aa739, 0xe4a30d4d, 0xa66a5367, 0x5b7a0faa
				};
			}
		}

		public override uint[] ExpectedABmodN {
			get {
				return new uint[] {
					0x7c0a7c37, 0x27d8fe4b, 0x35515a67, 0xaa463259, 0xcd4cb21f, 0x8cd44a21,
					0xd714ad84, 0xa0eec864, 0x18bb7dc3, 0x0288bd10, 0xb984d13f, 0xcb47077f,
					0x497ae9e5, 0x5057d121, 0x803c41e4, 0x47a7ccca, 0x5444f9c6, 0x7da937a9,
					0x287c933d, 0x0a9abc28, 0xc9814868, 0x22fe182d, 0x7cb6444e, 0x43712eac,
					0x1f5d963f, 0x1f174bb6, 0x8ae95e09, 0x85fde92d, 0x6a9f2892, 0x117f4ecf,
					0x44c2740f, 0x1729d81b, 0x2916ef2e, 0x9965857e, 0xd67dc5e2, 0xe039fc9a,
					0x02ffd9ed, 0x7e451f80, 0x852196a9, 0x6ed05db5, 0xa65fc5d3, 0x2cb0a039,
					0x77788359, 0xfb0988fc, 0x1f6e1a19, 0x2d870b2a, 0x388a9fc7, 0xee8a57a2
				};
			}
		}

		public override uint[] ExpectedApowBmodN {
			get {
				return new uint[] {
					0xdef729f4, 0x97ae2cff, 0xefbdc69a, 0x9fea6ffc, 0x5af64b95, 0x17f0096c,
					0x7d46370b, 0xf3165a84, 0xed36e796, 0xeeb36680, 0x31d166ba, 0x1d6c4fdf,
					0x1f68facb, 0x99b63244, 0x818d2bbe, 0xd9080814, 0x64def95a, 0xbdfd2e71,
					0xadf7247a, 0x4a55b36d, 0xc0e691fe, 0x867a5253, 0xdb3102ff, 0x5fa504df,
					0xcee737a7, 0x56c2e73c, 0x292696bc, 0xaf12a328, 0x9a8a3d65, 0x0d192229,
					0x680ab237, 0xd88b4fc9, 0xa4da89bc, 0xb8a963ee, 0xe72599ca, 0x8bbf96be,
					0x451eda43, 0xb6974be3, 0xa8f163b4, 0xcb2cde4f, 0x8aa10d21, 0x555d8c10,
					0x28b81ff8, 0x5470a44c, 0xdbb20b8d, 0xf45893e8, 0x461b780e, 0x60de5279,
					0x4c0b0853, 0xb54e0441, 0x3c4c09cd, 0x1e9d03ff, 0xa6e560df, 0x5ac703df,
					0x79d90e90, 0x1dd64cff, 0x06072f45, 0x1624cdd5, 0x156d4754, 0xd38557d8,
					0x72686502, 0x63e5c3bf, 0x508b9bdd, 0xeb3d9b77
				};
			}
		}
	}	

	public class ModRing_Rand590a469b1254nOdd : ModRing_Base{

		public override uint[] a {
			get {
				return new uint[] {
					0x2671, 0x3666eb30, 0x09789d24, 0xcd1ac1c5, 0x6103d748, 0x69a14942,
					0xe461353e, 0x5d3a190f, 0x8437844f, 0x7ab8dd34, 0x5ac7fcd3, 0x5dae9e69,
					0x8600ed0c, 0x3aa9bf06, 0xab7aa9c4, 0xa1cc1714, 0xddaa859c, 0x6af3ee8b,
					0x5f4e0b3b
				};
			}
		}

		public override uint[] b {
			get {
				return new uint[] {
					0x1da461, 0x0dd2d566, 0x7a96bd2f, 0xe1fac173, 0xf4b996dd, 0x376e2338,
					0x87e77f63, 0x95d3a106, 0xff6d4639, 0x2d95159c, 0xdbff083e, 0x97063aa6,
					0x3b123df3, 0x8f133be7, 0x02b3b93b
				};
			}
		}

		public override uint[] n {
			get {
				return new uint[] {
					0x26, 0x62310da0, 0x88cc2f54, 0xd36bd5db, 0xcd7c8ca4, 0x457eaefa,
					0xb464bbc1, 0x6a20a66f, 0x2fd79eff, 0xe7b0bd1f, 0x96ba2341, 0x6b59fb18,
					0xffa9f763, 0x07cdf47b, 0xee59b4eb, 0x7a830cc9, 0x9c789b94, 0x70e3020b,
					0x4d57ac72, 0x6f7f285c, 0xcb9de82c, 0xd98600c3, 0x5329d3de, 0xc11da7ad,
					0xb68677e5, 0xb46d2b40, 0xa5232ce9, 0x2540607f, 0xced2d3d5, 0xa0aeadfa,
					0x3c5b0f1d, 0x711e57cc, 0xf823b56e, 0x9aa878d2, 0x12698e33, 0x1332009c,
					0xe4b45668, 0x162aef52, 0xe567f602, 0x45a5e53f
				};
			}
		}

		public override uint[] ExpectedABmodN {
			get {
				return new uint[] {
					0x4, 0x7382437b, 0x98c86614, 0xebc99e94, 0x89a7b7af, 0xaadd2c1e, 0xa6c5e90e,
					0x3ad5f20a, 0xf0860ad6, 0xf3e772c1, 0x7a6ae056, 0x4b530366, 0x84ff9e09,
					0x7c08f4ea, 0x22d26c24, 0x9c88201f, 0x87aed25d, 0xe8dddca0, 0x8e5e8dc9,
					0x35b97b46, 0x23e98905, 0x19828491, 0xd8472d94, 0x7f748e3b, 0x45c8f371,
					0x6fd82ed8, 0x85fc9e0b, 0x293dedd9, 0x6909f6d4, 0xe3a03720, 0xc5bc82c1,
					0xb1a2468f, 0x9630ace3, 0xad5b3999
				};
			}
		}
		public override uint[] ExpectedApowBmodN {
			get {
				return new uint[] {
					0x1c, 0x979b11e8, 0x5f2b4727, 0x2e39e3e5, 0x3751703f, 0x66a22c9d,
					0x00a4469f, 0xbfe1577a, 0xa8849b81, 0x838be2bf, 0xff72d871, 0xe666020b,
					0xc291a1af, 0x6a34f362, 0x8f424749, 0x25cf86aa, 0x94728243, 0x8d3a7ff9,
					0x657d3620, 0x8603acaf, 0xee303077, 0xa6996893, 0xda430b67, 0xb90b024b,
					0x6ee1f3eb, 0xa3dd9e45, 0x2bd5457a, 0xafaa03b4, 0xd8b9fd3b, 0xf245d679,
					0xaa7ab8bb, 0x58309824, 0xa5f61807, 0xcb4db43e, 0x1ea8a927, 0x2a4a06e2,
					0x755c7a20, 0x817b2159, 0x894a6b13, 0xee000e95
				};
			}
		}
	}	

	public class ModRing_Rand590a469b1254nEven : ModRing_Base{

		public override uint[] a {
			get {
				return new uint[] {
					0x3e9f, 0xd2596dcd, 0x67136f83, 0xee4247fa, 0x5467651f, 0x56adf11f,
					0x6082842b, 0x742583c0, 0x7cbeb81f, 0xe9c584ad, 0x7b47e2f4, 0x244b49cf,
					0x1b6c1401, 0x281def78, 0x41d8f353, 0x831bfda5, 0xd039e6c9, 0xd1c8159d,
					0x7aeec959
				};
			}
		}

		public override uint[] b {
			get {
				return new uint[] {
					0x1a0919, 0x6536681e, 0xdbd4c7f5, 0xc653a5d7, 0x88f6eedb, 0xe3f69065,
					0x066d5af3, 0x3289fae7, 0x1bf4d48a, 0x9b011bf4, 0x0ff4d26f, 0x399c4464,
					0xb2b764f3, 0x6d21020c, 0xde1a2d59
				};
			}
		}

		public override uint[] n {
			get {
				return new uint[] {
					0x3e, 0x295d2985, 0x164c22dc, 0x3a6128cd, 0x45b6a280, 0x92b61b3a,
					0x0957227f, 0x2041c0c4, 0x205c2938, 0x5793ca63, 0xccb0d642, 0x5b9204e2,
					0x84c4b2ec, 0x11cdb3bf, 0xe7a3858f, 0x4ed770fc, 0xc2269113, 0x38b4044f,
					0x6a59f46c, 0x3e8ca3d2, 0x044d6148, 0xf18fa77d, 0xb4959b89, 0xc77f3ac9,
					0x1f3595be, 0xedce0d87, 0x26e4c194, 0x337db4ce, 0x12f2bd30, 0x62aa08b6,
					0x3e18c96c, 0x321663ed, 0x5c74c6ca, 0x529d7bcf, 0xb38bd2e0, 0xd9970cd3,
					0xf7c5874a, 0xf5103737, 0x9639ac05, 0xa16d4852
				};
			}
		}

		public override uint[] ExpectedABmodN {
			get {
				return new uint[] {
					0x6, 0x5e7531d8, 0x33a08acd, 0x07838202, 0x012250f7, 0xfc43ded9, 0x00f247f8,
					0xe7b5a24e, 0x9f49ef28, 0x8ef0ee52, 0x60da822f, 0x32e9135e, 0x7de3932c,
					0x3bd3fd25, 0x17da61e3, 0xf0ee25fa, 0x07960690, 0x647d5e51, 0xe2c6f21e,
					0x46fb3a67, 0x8eba709a, 0xb2d6e766, 0xa071ed0a, 0x3a39600f, 0x6569793a,
					0x7b35ba52, 0x23ea1910, 0x84c3b4f0, 0xc204e635, 0x08b731b0, 0x24fe8d53,
					0x0a3d2d70, 0x5732e363, 0x5772a4f1
				};
			}
		}
		public override uint[] ExpectedApowBmodN {
			get {
				return new uint[] {
					0x2e, 0x18a456d5, 0x0831ce8f, 0xfd9ddaff, 0xcc27c3b7, 0xdf21c0e1,
					0x3be1f9a3, 0x06eceff2, 0x2aee2c2f, 0xfac4975b, 0x193bd236, 0x9b41a85b,
					0x97e771f6, 0x022ac7e2, 0xa9b9c69a, 0x283652b0, 0x92805f97, 0x954b0b84,
					0x1b33e668, 0xa4b696e2, 0xda3aa6ec, 0x196d2c5b, 0xc725b47c, 0xf8649d83,
					0x9d37c75a, 0x922347ae, 0x6260eeca, 0x3383e1b6, 0xe694d189, 0x201e9892,
					0x24c7cbb5, 0x381ddae5, 0xf4028195, 0xed621a01, 0x0fb29180, 0x6da487b7,
					0x74e193c2, 0x3970acab, 0x73965353, 0xefcd901f
				};
			}
		}
	}
}
