PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE blob(
  rid INTEGER PRIMARY KEY,
  rcvid INTEGER,
  size INTEGER,
  uuid TEXT UNIQUE NOT NULL,
  content BLOB,
  CHECK( length(uuid)==40 AND rid>0 )
);
INSERT INTO "blob" VALUES(1,1,160,'85d5623f065ba80b20a035dcb4f9aea045215406',X'000000A0789C1DC8BD0E82301000E0BD4F71334993FE1CB465D507300617C352AED7D0208D011C787BA3E3F75DA0D47294F81A775EDFC739EE34332DB2547105A3B492DA48AD078D7D1B7A6BC54DDC21A14E9E52F059A9C928E4E0950AC133658FC6B118A099B6586986068EED5397DFECE72AFF80463C206DB37802C69CACCB31B8EC983B424D2D2361B04645EE92F802B1932DED');
INSERT INTO "blob" VALUES(2,2,10,'da5c8346496f3421cb58f84b6e59e9531d9d424d',X'0000000A789C73E472E272E672E172E5020008CA0182');
INSERT INTO "blob" VALUES(3,2,10,'ed24d19d726d173f18dbf4a9a0f8514daa3e3ca4',X'0000000A789CF3E6F2E1F2E5F2E3F2E7020009F601B4');
INSERT INTO "blob" VALUES(4,2,10,'278a402316510f6ae4a77186796a6bde78c7dbc1',X'0000000A789C73E372E7F2E0F2E4F2E202000960019B');
INSERT INTO "blob" VALUES(5,2,325,'69cc5363f67013c09bf506e3fe9533c32d0bc1ef',X'000000AF789C05C1C10AC2300C00D07BBF621FB0439A365B3B2F0351F426CA2EB24BBAA4AC3005D7FD3FBE47645EC3B96191B91EEBAE3AD7F22D47E16DAEB96C5AEFE3B5F5030E00388DF6D1DADF1048A84397A1A3C401120283235992CF9195C1135AF2D09967B308E788392FA187B8B0042F2E893AC60E803499A9917D35EF2670C09853E0A8092893EF859CB33D6A8414351AFCF0ED72FA03D5E231F2');
INSERT INTO "blob" VALUES(6,3,190,'3bfa21d09f8718adc3195848d57114e1fbf564fe',X'000000BE789C8DCC3B0EC2300C00D03DA7C88E2AF9A32475678E5016C49238B6400206D285DB036261E400EFED2301C2843421AE9816A02595B0C65DAF9BC52CAA89337B2E80AC20CD1364633749CCCAD4A1299AFF24A7F15D003ECB78DEA656875D2FF7FFB77088FD710EC758BA6095590C082BEAECEC4AC58CDEBEA2617801EE253190');
INSERT INTO "blob" VALUES(7,4,10,'35815cf5804e8933eab64ae34e00bbb381be72c5',X'0000000A789C0BE00AE40AE20AE60AE102000A8C01CD');
INSERT INTO "blob" VALUES(8,4,364,'341db367709dc7bc5046ab4fda4f7d9423118cba',X'0000016C789C35CE3B4E44310C85E1FEAE221B1864C78F24B4206A84A0413476EC888A918641B07CEE0CA23D3A9FF4DF158B78FB5CC7AFD3CDF9E7BCDD970A0807AC07C467945BE05B94EDA1FC1F0A4947994B3A70F64194E6CA96C409E0EED4D1B3D57931C78FBC9230999D5879E822AE385DFAEAEC9A327208618CE0CAB193F3FB29FF50C6BEE0885635B0D1C21EBED886C1EA821C6694348D2FE8FB7825B57563A8842A084B2DD95AC3AE6DA8A947B63E5BF8C4EDB1E8985348696903A409C3978026AD4B0F4DAA01FB31D7F65422C1AC73A4A3D5BD7CEF07016B16BBB5C9DB4B89D3FBF65A6C7873C33052034A6D94E82CAED85BA4ACED1765FC64F9');
INSERT INTO "blob" VALUES(9,5,294,'9223b4cad40c0bc997b747fe4eee586559a43815',X'00000126789C8D8E310E83300C45774E91B955243B714860EE11E85275B16322A4AA0C0186DEBEA00E5DD9FEF2FE7B37E300C1A2B38803861EA8F7D40CE62295E73C194FA8E2DB18A1D31C2507A096858A3295A81D398F98B2B0918A07B67CDE769FA7B99DB92AAFE379D1BFF7B9FC8231EC2FF630AF759B5FE7DD77A3756A1EC68D0C3E69424DA20E3460804C259172F15E52F305DF884EE5');
INSERT INTO "blob" VALUES(10,6,10,'8f09bc55a60eb8ca06f10a3b577aafa869b31695',X'0000000A789C0BE50AE30AE78AE08AE402000B2201E6');
INSERT INTO "blob" VALUES(11,6,426,'3d5bce2e44a6b39205eb514c581aa41d86f48540',X'00000116789C458ECB4A04311444F7F98AAC075BEE23B949DA8DA01F203A832082E471C30C6A2FBA47D1BF37BA7157A7288A23DDBCCC3736B7F6BCF5D3A75E9EBFCEE6D612204C4813E21EFD0C7E266AD78F177C9829C4EC8018C52374C9EA7208182524C9529A8658432B15CD9D9554AB67E12E01902BA4D23D8872D7E4992B538331D46EEE6D23AA320E1CE4C6B1A5CCDDA973181C6BF705CCDEEECA9A977AB43B5B56FAE5EDFB7D1AD1EE064C7F90377D3B2DFADF9CD78FE575E0C1B6F5689E6C57284961887A14A89A628B340C2825E118C020A6F0E0AE7E00A7744B2A');
INSERT INTO "blob" VALUES(12,7,10,'c6536e40b3d4755ead483c2e0fb2f16ecb751b6a',X'0000000A789C33E032E432E232E632E1020006CC012D');
INSERT INTO "blob" VALUES(13,7,424,'b95701e0b73e5ebf452a9a7ae00360bf7fd187fd',X'000001A8789C4590414F83310886EFDFAFE879C90C9496B65E359E8DD18BF10285668B3A936F33EABFB753136FBCC003BC5C05317B3A1EF79F17A7CFD3721D22206C316E11EF315F025FC6B8DC84B7839FEBC124F74A8953E3412962D75C474DCA9E9BB74C68CD524C3691BF91A17326F6044A964ACE2E962AF5E830340E64EF5A322ACB444EBBD57FF7B8CD21D8AC44362C34B09A8E244D60D48CC944C8A94B3A431F6F3F482C55124442CE0883C5939482954B6361352FB517D38ECB6DE0D6FB3C8A061740EAD0746460A771B6409DA2C16CF4B1DC85311D4D9AA4E4DEB21924D10AAA0834AD132CF761A3AB1CFA2E6C82AE74D6C7AFD7ED0CC3668AED8F90A3BFEC0FFE9F39ADEF87E7291F82ADBBE5312895341D420637C74AB5CD6F5185E23AC41B2FDF3224768A');
INSERT INTO "blob" VALUES(14,8,11,'6f525ab779ad66e24474d845c5fb7938be42d50d',X'0000000B789C73E4728AE072E672E172E502000C1801DA');
INSERT INTO "blob" VALUES(15,8,319,'c19f6ae71a35cddef0d5de3e1e6109c4378c8215',X'000000E0789C0DCA314E04310C05D03EA7C80158E41F27F6646890587A844048681B274E986A4762B6A0E2ECF0EA977FC3B63EC5BED9F56B1C97E3B65F8EFD3AEE6F3FB7708E894027A413F086B292AE00F6C7ED2E7DAC4917CB94185240536C6453C5225AC5A4F9D0A5ABB78EF012A5F65E58788A12B8536DB3900C9EA316E6CEC9E93F8E195EA361641573481EA5D6E900235B422FD49435BC47FFDEC2672469A9CEC98AAEE685672ECD45B28FEA8B590BA99D9FBD3DFC010C0C3CFF');
INSERT INTO "blob" VALUES(16,9,11,'b262fee89ed8a27a23a5e09d3917e0bebe22cd24',X'0000000B789C73E372E7F288E0F2E4F2E202000C5A01F3');
INSERT INTO "blob" VALUES(17,9,319,'41a02f2b2277d771d85e7f1202c82d4d6675662f',X'000000D8789C0DCE3B4E03410C00D07E4EB107D820DB63CF8F668B488882068890E8BCB6478806258A142ACE4E0EF0A4C77FE96983F56DDC7E1EAEBFD7745C08100E4807C47794017590206CDFAB8F7062C7EE958A63CD139BEF93B52BCC26C8AE9A239BF265A39715CFC3B0CFA25151B3987B4C70F1C8815110BA71AECD1AA1A4D785F5AE4929B07397CADE729F6462358A36F3745AFCF2953E17C9AD30766AA5CE3DD8E27EA1BD548FD80D9C533E3F9FE6C7E33F8FCE3AED');
INSERT INTO "blob" VALUES(18,10,187,'6c22c86ee8a603f5e18171efb6ff571b59e35cf3',X'000000BB789C8DCCAD0EC230140650DFA7A8274BFAB5B4B7ADE611862198EEFE30038261787B9843A24F724E3E068409710266E41E6A4776B33FC878A967342B4309236516510B924593420B42E363A2CA3522FF24D76D5FA803FBB2BDEF13AF8F1BFEAEDCD9CB7375176F45D8961C858C9651BED86C080189381621F701B249318A');
INSERT INTO "blob" VALUES(19,11,187,'8b9f82378ea7a5f9ef8e80d31929f6dfab988acc',X'000000BB789C8DCC3D0EC2300C06D03DA7C88E22D95F623BEACC11CA8258F24B1718280BB747DD18790778670F620A8CC0BCB22C9497486EF5A75EDEC3272E84890A987533EE59864D06A165F4D4554D54317F92DB7E2CB6408E65FF3C42DB9E77FC5DB98BEFAFCD5DBD0C9E604819AC31D5A489F2906AA5C5AAA4C57D01A0C52E74');
INSERT INTO "blob" VALUES(20,12,11,'64a8a5c7320fccfa4b2e5dfc5fd20a5381a86c5b',X'0000000B789CF3E6F2E1F2E5F28BE0F2E702000CA7020C');
INSERT INTO "blob" VALUES(21,12,321,'5a71ecd64585155b076a4f1e4d489eb5fe3d05f4',X'00000141789C3D8F314E04310C45FB9C221758643B719C6C0BA246081A44E3C40E53ED48BB23C1F1095B50B8F8FA7A4FDF8F716C7AF9F2DBE7EDD8D76D57F787E3E7084F9100E18474427C433E239D81C273DC2FF73E96C9C4DA459A5A294E394BB69A79F0ECD252ED9EC9186C21FFD258B256E52189608E31357772B6B91823504E15B596C1FD0FFADEEF48A742D3BD36B7AA244A49D9A1596A280EDDBB130DA31C5E6246059AD489444C04ADB2CB44021A952CAF99C265D9C2EBB2226371186AA4C35704D7C252C0B06A1FE13DDA750B1F9111E6C4543CF1C4A1136606582F0FE406D424FC021EAB59DA');
INSERT INTO "blob" VALUES(22,13,187,'a2c1640c98b3059a83df0b597d673ad073b782de',X'000000BB789C8DCC310EC2300C00C03DAFC88E22D9899DA49D794259108B93D874818176E1F7805818994FBAA38F80103006C40579C63863718B3F0CD9D5B314D43E327165646E50B290A1D2A03A6963D334808D7E92CBF65D207E96ED790B7DBD5FD3DF953BF9F158DDD96B1EB1D91B92285649B917AD5627A8066842EE05469C30D4');
INSERT INTO "blob" VALUES(23,14,10,'6e167b139c294bed560e2e30b352361b101e1f39',X'0000000A789C33E532E332E7B2E0B2E4020007620146');
INSERT INTO "blob" VALUES(24,14,388,'8015e80a2391d4497530b5d0f36689f359e374ba',X'00000184789C4590314FC4300C85F7FE8ACC2715D971E234C7086246E8585017277174086851DBD3C1BF27BD85CDCFF6A7F7EC075396F97B5CE749EFC7554A19D749AFE35AE7CBD23D1A0B083DDA1EF184FE8874F4DC3D997D78B7FD6C86153924A4986D74498B6750AB0489BC25C684808A956263B6F3A27A83B45857309660B960A08A4349D54914A88347574448298BDBA1EB7C436C18C48125648F5059D449083870882C9C8A862187923276CF8663CE9E982A0740CA1053F5C04A55A327CA640BB445ADDD8B69E611497373AF425407B0FB19A145C6C04CDDC91CD222533E9B83498BDBF5FAFBD5B7D21C9AE86F4256FD7C9FF4BFB32D97E9A3C9D7F6DA73F7666A96907CB351CB9A23D89CAB44675B50715CA8FB033C856E21');
INSERT INTO "blob" VALUES(25,15,11,'e866bb885d5184cba497cfb6a4eb281688519521',X'0000000B789C73E472E272E672E1728DE002000AF201DA');
INSERT INTO "blob" VALUES(26,15,372,'b882b17dc56af1e0297bf8a57c9d15050215c64a',X'00000174789C458E414B04310C85EFF32B7A5E1869D23669BD2A9E45D68B78499BD41175166657D47F6F7711841CF2F2DE47DE8D6B8BAC2FF67C3CAC36DD3AF4E067C019600FE97A0CD274E7867775FA3E39CB44B5E69C34418EAD4A2CDC7A25895631030D074A4218C869D9EC0F528C0A451949814387ACB54729E2FB88471509169AC433F475B820C859A2C70094C077128BC20C99B8905055E3DC586B83E9DE51692D050A9DD84368BED49E3C59E85652082DA0FA11B43E3D38EB297266D4D414C427E30E56C2E8D0A1F9D4A7BDDBD54DD6B6B89DAB5B3AEBE3CFC73C56B71B62BE0839DAFBEB6AFF97D3F6B9BE0DF9E8745BA6A7F1463B76C4AC68218D9A1AA216C2D822D4C63CFD0205E667AF');
INSERT INTO "blob" VALUES(27,16,11,'e09593950837f76e70ca2f8ff2272ae3df0ba017',X'0000000B789CF38EE0F2E1F2E5F2E3F2E702000DB2020C');
INSERT INTO "blob" VALUES(28,16,341,'9df70ff13b57e70ea2de63f655eb72df7b83121a',X'000000EF789C0DCD3D4E03311040E1DEA7F001089AF17AFE360D52525220040D8A846C8FAD5004A4CD8AE5F86CF99AEFD173B8CDA7D8FD6BBDDCD7EBD2FBF1725FFA77B9F5BDB79F708E09100E980E886F4833F28C80BF4FFE90C69C444B86342113C2E0D273114165312E5CBD8B36F1DA306E71B71ED7BF35BCC4AA9A2A8A37E232B04332A9430B493347028284D43897F01AD5D4B077A326640C5981477611A324FB7A84F7E8CB357C441BD51C9407541D0A669433FBA05C26622E14A6069F1B1FFF019008411F');
INSERT INTO "blob" VALUES(29,17,11,'5ebb3c9ad50740a7382902657b84a6105c32fc7b',X'0000000B789C73E372E7F2E0F28CE4F2E202000C0101F4');
INSERT INTO "blob" VALUES(30,17,322,'94bd3e6b45cc15e86cc76ecfd2207fddbb675b15',X'00000142789C3DCE314E44310C04D0FE9F221758643B711C6F0BA246081A441327B696825D69F9121C9F8010F5F8CDF836F97CDB5F3FF6CFCBE1EAE7FEEEDB5D224038201D109F908F588F85B6FB7439FBCDFEB5276FB59AB5C693B19561BDA88CB0DA8B1B35AC2B4165C245F6D3D5FF10286B56869625A4BAC0E8142D8248A87B9E01D601E507FDBFF22BD9CDF2D03E19A44097DC48812A8BB5D22B028F4C31C4B687A4330422301BCB5AF04ED36B8ECAAB436885D63212F6ED31E56985D1EB2A96A22DFA8800CC6C485A88FAF69CE6F5B4BD24556990111A87AECBEEEAB50C5F8EAB308FED1BE1CB587B');
INSERT INTO "blob" VALUES(31,18,11,'85286cb3bc6d9e6f2f586eb5532f6065678f75b9',X'0000000B789C73E372E7F2E0F2E4F28AE402000BA301F4');
INSERT INTO "blob" VALUES(32,18,360,'333c4d56d218735e20565944b50202f24827e3b8',X'00000168789C25CF3D4E43311004E0DEA7F00582BCDE1FAFD382A8118206D1ECDA5E250D91C213E1F83C9476349F34F398D73C6F9FDFDBED929E722D500E500F006F20472A47C4F49CE3FCB31EB6DF2D6B94EE83D9A42CD76145028AA1736B66612ADD11A4F36E2E5F77328D8722097509A40AC35943C965715F9D11669F5469EE643B5DD71DADB927D067AB32A161804E0FB26E259481A6192E1C46FFE876B94FE3AA321C7DC8EC4BA206AB2C67C61A5284A56934F69E5E324EF6B1EA223271ECB5F0DE031AAC604630558294A9A4D76C4B54753F568B8B16F4D5102946AD4EA1BAD27B9ED753FAC80338F6EBB37A31F568AD888A556519A32B78FA037C076278');
CREATE TABLE delta(
  rid INTEGER PRIMARY KEY,
  srcid INTEGER NOT NULL REFERENCES blob
);
INSERT INTO "delta" VALUES(5,8);
INSERT INTO "delta" VALUES(11,32);
INSERT INTO "delta" VALUES(15,17);
INSERT INTO "delta" VALUES(17,21);
INSERT INTO "delta" VALUES(28,30);
CREATE TABLE rcvfrom(
  rcvid INTEGER PRIMARY KEY,
  uid INTEGER REFERENCES user,
  mtime DATETIME,
  nonce TEXT UNIQUE,
  ipaddr TEXT
);
INSERT INTO "rcvfrom" VALUES(1,1,2455542.12469579,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(2,1,2455542.12638891,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(3,1,2455542.12705387,NULL,'127.0.0.1');
INSERT INTO "rcvfrom" VALUES(4,1,2455542.12796271,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(5,1,2455542.12818105,NULL,'127.0.0.1');
INSERT INTO "rcvfrom" VALUES(6,1,2455542.12873891,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(7,1,2455542.1294266,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(8,1,2455542.12999842,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(9,1,2455542.13015219,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(10,1,2455542.13073123,NULL,'127.0.0.1');
INSERT INTO "rcvfrom" VALUES(11,1,2455542.13090438,NULL,'127.0.0.1');
INSERT INTO "rcvfrom" VALUES(12,1,2455542.1333612,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(13,1,2455542.13353873,NULL,'127.0.0.1');
INSERT INTO "rcvfrom" VALUES(14,1,2455542.13467894,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(15,1,2455542.13571911,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(16,1,2455542.13623403,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(17,1,2455542.13660848,NULL,NULL);
INSERT INTO "rcvfrom" VALUES(18,1,2455542.19483546,NULL,NULL);
CREATE TABLE user(
  uid INTEGER PRIMARY KEY,
  login TEXT,
  pw TEXT,
  cap TEXT,
  cookie TEXT,
  ipaddr TEXT,
  cexpire DATETIME,
  info TEXT,
  photo BLOB
);
INSERT INTO "user" VALUES(1,'drh','efbbd0','s',NULL,NULL,NULL,'',NULL);
INSERT INTO "user" VALUES(2,'anonymous','42568D1800352E28','ghmncz',NULL,NULL,NULL,'Anon',NULL);
INSERT INTO "user" VALUES(3,'nobody','','jor',NULL,NULL,NULL,'Nobody',NULL);
INSERT INTO "user" VALUES(4,'developer','','dei',NULL,NULL,NULL,'Dev',NULL);
INSERT INTO "user" VALUES(5,'reader','','kptw',NULL,NULL,NULL,'Reader',NULL);
CREATE TABLE config(
  name TEXT PRIMARY KEY NOT NULL,
  value CLOB,
  CHECK( typeof(name)='text' AND length(name)>=1 )
);
INSERT INTO "config" VALUES('server-code','48d0adf1afd58dae13c5b70ff7aff208fb8b9f53');
INSERT INTO "config" VALUES('project-code','8201587e22864f2fe6b8eb623626de6f9f747058');
INSERT INTO "config" VALUES('autosync','1');
INSERT INTO "config" VALUES('localauth','0');
INSERT INTO "config" VALUES('project-name','Test Case 1');
INSERT INTO "config" VALUES('project-description','Fossil repository for testing');
INSERT INTO "config" VALUES('index-page','/timeline');
INSERT INTO "config" VALUES('content-schema','1');
INSERT INTO "config" VALUES('aux-schema','2010-11-24');
CREATE TABLE shun(uuid UNIQUE);
CREATE TABLE private(rid INTEGER PRIMARY KEY);
CREATE TABLE reportfmt(
   rn integer primary key,
   owner text,
   title text,
   cols text,
   sqlcode text
);
INSERT INTO "reportfmt" VALUES(1,NULL,'All Tickets','#ffffff Key:
#f2dcdc Active
#e8e8e8 Review
#cfe8bd Fixed
#bde5d6 Tested
#cacae5 Deferred
#c8c8c8 Closed','SELECT
  CASE WHEN status IN (''Open'',''Verified'') THEN ''#f2dcdc''
       WHEN status=''Review'' THEN ''#e8e8e8''
       WHEN status=''Fixed'' THEN ''#cfe8bd''
       WHEN status=''Tested'' THEN ''#bde5d6''
       WHEN status=''Deferred'' THEN ''#cacae5''
       ELSE ''#c8c8c8'' END AS ''bgcolor'',
  substr(tkt_uuid,1,10) AS ''#'',
  datetime(tkt_mtime) AS ''mtime'',
  type,
  status,
  subsystem,
  title
FROM ticket');
CREATE TABLE concealed(
  hash TEXT PRIMARY KEY,
  content TEXT
);
CREATE TABLE filename(
  fnid INTEGER PRIMARY KEY,
  name TEXT UNIQUE
);
INSERT INTO "filename" VALUES(1,'four.txt');
INSERT INTO "filename" VALUES(2,'one.txt');
INSERT INTO "filename" VALUES(3,'three.txt');
INSERT INTO "filename" VALUES(4,'two.txt');
INSERT INTO "filename" VALUES(5,'five.txt');
INSERT INTO "filename" VALUES(6,'six.txt');
INSERT INTO "filename" VALUES(7,'two-rename.txt');
CREATE TABLE mlink(
  mid INTEGER REFERENCES blob,
  pid INTEGER REFERENCES blob,
  fid INTEGER REFERENCES blob,
  fnid INTEGER REFERENCES filename,
  pfnid INTEGER REFERENCES filename
);
INSERT INTO "mlink" VALUES(8,0,7,1,0);
INSERT INTO "mlink" VALUES(5,0,2,2,0);
INSERT INTO "mlink" VALUES(5,0,3,3,0);
INSERT INTO "mlink" VALUES(5,0,4,4,0);
INSERT INTO "mlink" VALUES(11,0,10,5,0);
INSERT INTO "mlink" VALUES(13,0,12,6,0);
INSERT INTO "mlink" VALUES(21,3,20,3,0);
INSERT INTO "mlink" VALUES(17,4,16,4,0);
INSERT INTO "mlink" VALUES(15,2,14,2,0);
INSERT INTO "mlink" VALUES(24,0,23,1,0);
INSERT INTO "mlink" VALUES(24,2,0,2,0);
INSERT INTO "mlink" VALUES(26,2,25,2,0);
INSERT INTO "mlink" VALUES(30,4,29,7,0);
INSERT INTO "mlink" VALUES(28,3,27,3,0);
INSERT INTO "mlink" VALUES(28,4,4,7,4);
INSERT INTO "mlink" VALUES(28,4,0,4,0);
INSERT INTO "mlink" VALUES(32,4,31,4,0);
CREATE TABLE plink(
  pid INTEGER REFERENCES blob,
  cid INTEGER REFERENCES blob,
  isprim BOOLEAN,
  mtime DATETIME,
  UNIQUE(pid, cid)
);
INSERT INTO "plink" VALUES(5,8,1,2455542.12795139);
INSERT INTO "plink" VALUES(1,5,1,2455542.12638889);
INSERT INTO "plink" VALUES(5,11,1,2455542.12873843);
INSERT INTO "plink" VALUES(5,13,1,2455542.1294213);
INSERT INTO "plink" VALUES(17,21,1,2455542.13335648);
INSERT INTO "plink" VALUES(15,17,1,2455542.13015046);
INSERT INTO "plink" VALUES(5,15,1,2455542.12998843);
INSERT INTO "plink" VALUES(5,24,1,2455542.13467593);
INSERT INTO "plink" VALUES(5,26,1,2455542.13571759);
INSERT INTO "plink" VALUES(28,30,1,2455542.13659722);
INSERT INTO "plink" VALUES(26,28,1,2455542.13622685);
INSERT INTO "plink" VALUES(11,32,1,2455542.19482639);
CREATE TABLE event(
  type TEXT,
  mtime DATETIME,
  objid INTEGER PRIMARY KEY,
  tagid INTEGER,
  uid INTEGER REFERENCES user,
  bgcolor TEXT,
  euser TEXT,
  user TEXT,
  ecomment TEXT,
  comment TEXT,
  brief TEXT,
  omtime DATETIME
);
INSERT INTO "event" VALUES('ci',2455542.1246875,1,NULL,NULL,NULL,NULL,'drh',NULL,'initial empty check-in',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.12638889,5,NULL,NULL,NULL,NULL,'drh',NULL,'add three initial files',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.12795139,8,NULL,NULL,NULL,NULL,'drh',NULL,'add four.txt',NULL,2455542.12795139);
INSERT INTO "event" VALUES('ci',2455542.12873843,11,NULL,NULL,NULL,NULL,'drh',NULL,'add five.txt',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.1294213,13,NULL,NULL,NULL,NULL,'drh',NULL,'add six.txt',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.12998843,15,NULL,NULL,NULL,NULL,'drh',NULL,'changes to one.txt',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.13015046,17,NULL,NULL,NULL,NULL,'drh',NULL,'changes to two.txt',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.13335648,21,NULL,NULL,NULL,NULL,'drh',NULL,'changes to three.txt',NULL,2455542.13335648);
INSERT INTO "event" VALUES('ci',2455542.13467593,24,NULL,NULL,NULL,NULL,'drh',NULL,'drop one; add new four',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.13571759,26,NULL,NULL,NULL,NULL,'drh',NULL,'change one',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.13622685,28,NULL,NULL,NULL,NULL,'drh',NULL,'edit three; rename two',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.13659722,30,NULL,NULL,NULL,NULL,'drh',NULL,'edit two-rename',NULL,NULL);
INSERT INTO "event" VALUES('ci',2455542.19482639,32,NULL,NULL,NULL,NULL,'drh',NULL,'edit two',NULL,NULL);
CREATE TABLE phantom(
  rid INTEGER PRIMARY KEY
);
CREATE TABLE orphan(
  rid INTEGER PRIMARY KEY,
  baseline INTEGER
);
CREATE TABLE unclustered(
  rid INTEGER PRIMARY KEY
);
INSERT INTO "unclustered" VALUES(1);
INSERT INTO "unclustered" VALUES(2);
INSERT INTO "unclustered" VALUES(3);
INSERT INTO "unclustered" VALUES(4);
INSERT INTO "unclustered" VALUES(5);
INSERT INTO "unclustered" VALUES(6);
INSERT INTO "unclustered" VALUES(7);
INSERT INTO "unclustered" VALUES(8);
INSERT INTO "unclustered" VALUES(9);
INSERT INTO "unclustered" VALUES(10);
INSERT INTO "unclustered" VALUES(11);
INSERT INTO "unclustered" VALUES(12);
INSERT INTO "unclustered" VALUES(13);
INSERT INTO "unclustered" VALUES(14);
INSERT INTO "unclustered" VALUES(15);
INSERT INTO "unclustered" VALUES(16);
INSERT INTO "unclustered" VALUES(17);
INSERT INTO "unclustered" VALUES(18);
INSERT INTO "unclustered" VALUES(19);
INSERT INTO "unclustered" VALUES(20);
INSERT INTO "unclustered" VALUES(21);
INSERT INTO "unclustered" VALUES(22);
INSERT INTO "unclustered" VALUES(23);
INSERT INTO "unclustered" VALUES(24);
INSERT INTO "unclustered" VALUES(25);
INSERT INTO "unclustered" VALUES(26);
INSERT INTO "unclustered" VALUES(27);
INSERT INTO "unclustered" VALUES(28);
INSERT INTO "unclustered" VALUES(29);
INSERT INTO "unclustered" VALUES(30);
INSERT INTO "unclustered" VALUES(31);
INSERT INTO "unclustered" VALUES(32);
CREATE TABLE unsent(
  rid INTEGER PRIMARY KEY
);
INSERT INTO "unsent" VALUES(31);
INSERT INTO "unsent" VALUES(32);
CREATE TABLE tag(
  tagid INTEGER PRIMARY KEY,
  tagname TEXT UNIQUE
);
INSERT INTO "tag" VALUES(1,'bgcolor');
INSERT INTO "tag" VALUES(2,'comment');
INSERT INTO "tag" VALUES(3,'user');
INSERT INTO "tag" VALUES(4,'date');
INSERT INTO "tag" VALUES(5,'hidden');
INSERT INTO "tag" VALUES(6,'private');
INSERT INTO "tag" VALUES(7,'cluster');
INSERT INTO "tag" VALUES(8,'branch');
INSERT INTO "tag" VALUES(9,'closed');
INSERT INTO "tag" VALUES(10,'sym-trunk');
INSERT INTO "tag" VALUES(11,'sym-baseline');
INSERT INTO "tag" VALUES(12,'sym-br1');
INSERT INTO "tag" VALUES(13,'sym-br2');
INSERT INTO "tag" VALUES(14,'sym-br3');
INSERT INTO "tag" VALUES(15,'sym-chng1');
INSERT INTO "tag" VALUES(16,'sym-chng2');
INSERT INTO "tag" VALUES(17,'sym-chng3');
INSERT INTO "tag" VALUES(18,'sym-br4');
INSERT INTO "tag" VALUES(19,'sym-br5');
CREATE TABLE tagxref(
  tagid INTEGER REFERENCES tag,
  tagtype INTEGER,
  srcid INTEGER REFERENCES blob,
  origid INTEGER REFERENCES blob,
  value TEXT,
  mtime TIMESTAMP,
  rid INTEGER REFERENCE blob,
  UNIQUE(rid, tagid)
);
INSERT INTO "tagxref" VALUES(8,2,1,1,'trunk',2455542.1246875,1);
INSERT INTO "tagxref" VALUES(10,2,1,1,NULL,2455542.1246875,1);
INSERT INTO "tagxref" VALUES(4,1,6,5,'2010-12-11 15:02:00',2455542.12704861,5);
INSERT INTO "tagxref" VALUES(11,1,6,5,NULL,2455542.12704861,5);
INSERT INTO "tagxref" VALUES(8,2,0,1,'trunk',2455542.1246875,5);
INSERT INTO "tagxref" VALUES(10,2,0,1,NULL,2455542.1246875,5);
INSERT INTO "tagxref" VALUES(8,2,9,8,'br1',2455542.1281713,8);
INSERT INTO "tagxref" VALUES(12,2,9,8,NULL,2455542.1281713,8);
INSERT INTO "tagxref" VALUES(4,1,9,8,'2010-12-11 15:04:15',2455542.1281713,8);
INSERT INTO "tagxref" VALUES(10,0,9,8,NULL,2455542.1281713,8);
INSERT INTO "tagxref" VALUES(8,2,11,11,'br2',2455542.12873843,11);
INSERT INTO "tagxref" VALUES(13,2,11,11,NULL,2455542.12873843,11);
INSERT INTO "tagxref" VALUES(11,0,11,11,NULL,2455542.12873843,11);
INSERT INTO "tagxref" VALUES(10,0,11,11,NULL,2455542.12873843,11);
INSERT INTO "tagxref" VALUES(8,2,13,13,'br3',2455542.1294213,13);
INSERT INTO "tagxref" VALUES(14,2,13,13,NULL,2455542.1294213,13);
INSERT INTO "tagxref" VALUES(11,0,13,13,NULL,2455542.1294213,13);
INSERT INTO "tagxref" VALUES(10,0,13,13,NULL,2455542.1294213,13);
INSERT INTO "tagxref" VALUES(4,1,18,15,'2010-12-11 15:07:11',2455542.13072917,15);
INSERT INTO "tagxref" VALUES(15,1,18,15,NULL,2455542.13072917,15);
INSERT INTO "tagxref" VALUES(4,1,19,17,'2010-12-11 15:07:25',2455542.13090278,17);
INSERT INTO "tagxref" VALUES(16,1,19,17,NULL,2455542.13090278,17);
INSERT INTO "tagxref" VALUES(8,2,0,1,'trunk',2455542.1246875,15);
INSERT INTO "tagxref" VALUES(8,2,0,1,'trunk',2455542.1246875,17);
INSERT INTO "tagxref" VALUES(8,2,0,1,'trunk',2455542.1246875,21);
INSERT INTO "tagxref" VALUES(10,2,0,1,NULL,2455542.1246875,15);
INSERT INTO "tagxref" VALUES(10,2,0,1,NULL,2455542.1246875,17);
INSERT INTO "tagxref" VALUES(10,2,0,1,NULL,2455542.1246875,21);
INSERT INTO "tagxref" VALUES(4,1,22,21,'2010-12-11 15:12:02',2455542.13353009,21);
INSERT INTO "tagxref" VALUES(17,1,22,21,NULL,2455542.13353009,21);
INSERT INTO "tagxref" VALUES(8,2,24,24,'br4',2455542.13467593,24);
INSERT INTO "tagxref" VALUES(18,2,24,24,NULL,2455542.13467593,24);
INSERT INTO "tagxref" VALUES(11,0,24,24,NULL,2455542.13467593,24);
INSERT INTO "tagxref" VALUES(10,0,24,24,NULL,2455542.13467593,24);
INSERT INTO "tagxref" VALUES(8,2,26,26,'br5',2455542.13571759,26);
INSERT INTO "tagxref" VALUES(19,2,26,26,NULL,2455542.13571759,26);
INSERT INTO "tagxref" VALUES(11,0,26,26,NULL,2455542.13571759,26);
INSERT INTO "tagxref" VALUES(10,0,26,26,NULL,2455542.13571759,26);
INSERT INTO "tagxref" VALUES(8,2,0,26,'br5',2455542.13571759,28);
INSERT INTO "tagxref" VALUES(8,2,0,26,'br5',2455542.13571759,30);
INSERT INTO "tagxref" VALUES(19,2,0,26,NULL,2455542.13571759,28);
INSERT INTO "tagxref" VALUES(19,2,0,26,NULL,2455542.13571759,30);
INSERT INTO "tagxref" VALUES(8,2,0,11,'br2',2455542.12873843,32);
INSERT INTO "tagxref" VALUES(13,2,0,11,NULL,2455542.12873843,32);
CREATE TABLE backlink(
  target TEXT,
  srctype INT,
  srcid INT,
  mtime TIMESTAMP,
  UNIQUE(target, srctype, srcid)
);
CREATE TABLE attachment(
  attachid INTEGER PRIMARY KEY,
  isLatest BOOLEAN DEFAULT 0,
  mtime TIMESTAMP,
  src TEXT,
  target TEXT,
  filename TEXT,
  comment TEXT,
  user TEXT
);
CREATE TABLE ticket(
  -- Do not change any column that begins with tkt_
  tkt_id INTEGER PRIMARY KEY,
  tkt_uuid TEXT UNIQUE,
  tkt_mtime DATE,
  -- Add as many field as required below this line
  type TEXT,
  status TEXT,
  subsystem TEXT,
  priority TEXT,
  severity TEXT,
  foundin TEXT,
  private_contact TEXT,
  resolution TEXT,
  title TEXT,
  comment TEXT
);
CREATE INDEX delta_i1 ON delta(srcid);
CREATE INDEX mlink_i1 ON mlink(mid);
CREATE INDEX mlink_i2 ON mlink(fnid);
CREATE INDEX mlink_i3 ON mlink(fid);
CREATE INDEX mlink_i4 ON mlink(pid);
CREATE INDEX plink_i2 ON plink(cid,pid);
CREATE INDEX event_i1 ON event(mtime);
CREATE INDEX orphan_baseline ON orphan(baseline);
CREATE INDEX tagxref_i1 ON tagxref(tagid, mtime);
CREATE INDEX backlink_src ON backlink(srcid, srctype);
CREATE INDEX attachment_idx1 ON attachment(target, filename, mtime);
CREATE INDEX attachment_idx2 ON attachment(src);
COMMIT;
